/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.FieldStatsCollector;
import org.apache.paimon.format.FileStatsExtractor;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    @Nullable
    private final FileStatsExtractor fileStatsExtractor;
    @Nullable
    private FieldStatsCollector fieldStatsCollector = null;

    public StatsCollectingSingleFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, Function<T, InternalRow> converter, RowType writeSchema, @Nullable FileStatsExtractor fileStatsExtractor, String compression) {
        super(fileIO, factory, path, converter, compression);
        this.fileStatsExtractor = fileStatsExtractor;
        if (this.fileStatsExtractor == null) {
            this.fieldStatsCollector = new FieldStatsCollector(writeSchema);
        }
    }

    @Override
    public void write(T record) throws IOException {
        InternalRow rowData = this.writeImpl(record);
        if (this.fieldStatsCollector != null) {
            this.fieldStatsCollector.collect(rowData);
        }
    }

    public FieldStats[] fieldStats() throws IOException {
        Preconditions.checkState(this.closed, "Cannot access metric unless the writer is closed.");
        if (this.fileStatsExtractor != null) {
            return this.fileStatsExtractor.extract(this.fileIO, this.path);
        }
        return this.fieldStatsCollector.extract();
    }
}

