/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;

public class CacheManager {
    private final int pageSize;
    private final Cache<CacheKey, CacheValue> cache;

    public CacheManager(int pageSize, MemorySize maxMemorySize) {
        this.pageSize = pageSize;
        this.cache = Caffeine.newBuilder().weigher(this::weigh).maximumWeight(maxMemorySize.getBytes()).removalListener(this::onRemoval).executor(MoreExecutors.directExecutor()).build();
    }

    @VisibleForTesting
    Cache<CacheKey, CacheValue> cache() {
        return this.cache;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public MemorySegment getPage(RandomAccessFile file, int pageNumber, Consumer<Integer> cleanCallback) {
        CacheKey key = new CacheKey(file, pageNumber);
        CacheValue value = this.cache.get(key, cacheKey -> {
            try {
                return this.createValue(key, cleanCallback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return value.segment;
    }

    public void invalidPage(RandomAccessFile file, int pageNumber) {
        this.cache.invalidate(new CacheKey(file, pageNumber));
    }

    private int weigh(CacheKey cacheKey, CacheValue cacheValue) {
        return cacheValue.segment.size();
    }

    private void onRemoval(CacheKey key, CacheValue value, RemovalCause cause) {
        value.cleanCallback.accept(key.pageNumber);
    }

    private CacheValue createValue(CacheKey key, Consumer<Integer> cleanCallback) throws IOException {
        return new CacheValue(key.read(this.pageSize), cleanCallback);
    }

    private static class CacheValue {
        private final MemorySegment segment;
        private final Consumer<Integer> cleanCallback;

        private CacheValue(MemorySegment segment, Consumer<Integer> cleanCallback) {
            this.segment = segment;
            this.cleanCallback = cleanCallback;
        }
    }

    private static class CacheKey {
        private final RandomAccessFile file;
        private final int pageNumber;

        private CacheKey(RandomAccessFile file, int pageNumber) {
            this.file = file;
            this.pageNumber = pageNumber;
        }

        private MemorySegment read(int pageSize) throws IOException {
            long length = this.file.length();
            long pageAddress = (long)this.pageNumber * (long)pageSize;
            int len = (int)Math.min((long)pageSize, length - pageAddress);
            byte[] bytes = new byte[len];
            this.file.seek(pageAddress);
            this.file.readFully(bytes);
            return MemorySegment.wrap(bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.pageNumber == cacheKey.pageNumber && Objects.equals(this.file, cacheKey.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.pageNumber);
        }
    }
}

