/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestFileMetaSerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestList
extends ObjectsFile<ManifestFileMeta> {
    private final FormatWriterFactory writerFactory;

    private ManifestList(FileIO fileIO, ManifestFileMetaSerializer serializer, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, PathFactory pathFactory, @Nullable SegmentsCache<String> cache) {
        super(fileIO, serializer, readerFactory, pathFactory, cache);
        this.writerFactory = writerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write(List<ManifestFileMeta> metas) {
        Path path = this.pathFactory.newPath();
        try {
            try (PositionOutputStream out = this.fileIO.newOutputStream(path, false);){
                FormatWriter writer = this.writerFactory.create(out, CoreOptions.FILE_COMPRESSION.defaultValue());
                try {
                    for (ManifestFileMeta record : metas) {
                        writer.addElement(this.serializer.toRow(record));
                    }
                }
                finally {
                    writer.flush();
                    writer.finish();
                }
            }
            return path.getName();
        }
        catch (Throwable e) {
            this.fileIO.deleteQuietly(path);
            throw new RuntimeException("Exception occurs when writing manifest list " + path + ". Clean up.", e);
        }
    }

    public static class Factory {
        private final FileIO fileIO;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        @Nullable
        private final SegmentsCache<String> cache;

        public Factory(FileIO fileIO, FileFormat fileFormat, FileStorePathFactory pathFactory, @Nullable SegmentsCache<String> cache) {
            this.fileIO = fileIO;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.cache = cache;
        }

        public ManifestList create() {
            RowType metaType = VersionedObjectSerializer.versionType(ManifestFileMeta.schema());
            return new ManifestList(this.fileIO, new ManifestFileMetaSerializer(), this.fileFormat.createReaderFactory(metaType), this.fileFormat.createWriterFactory(metaType), this.pathFactory.manifestListFactory(), this.cache);
        }
    }
}

