/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.util.LinkedList;
import java.util.List;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;

public class HeapMemorySegmentPool
implements MemorySegmentPool {
    private final LinkedList<MemorySegment> segments = new LinkedList();
    private final int maxPages;
    private final int pageSize;
    private int numPage;

    public HeapMemorySegmentPool(long maxMemory, int pageSize) {
        this.maxPages = (int)(maxMemory / (long)pageSize);
        this.pageSize = pageSize;
        this.numPage = 0;
    }

    @Override
    public MemorySegment nextSegment() {
        if (this.segments.size() > 0) {
            return this.segments.poll();
        }
        if (this.numPage < this.maxPages) {
            ++this.numPage;
            return MemorySegment.allocateHeapMemory(this.pageSize);
        }
        return null;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.segments.addAll(memory);
    }

    @Override
    public int freePages() {
        return this.segments.size() + this.maxPages - this.numPage;
    }
}

