/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.mergetree.DropDeleteReader;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.SortMergeReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.IOUtils;

public class MergeTreeReaders {
    private MergeTreeReaders() {
    }

    public static RecordReader<KeyValue> readerForMergeTree(List<List<SortedRun>> sections, boolean dropDelete, KeyValueFileReaderFactory readerFactory, Comparator<InternalRow> userKeyComparator, MergeFunction<KeyValue> mergeFunction) throws IOException {
        ArrayList readers = new ArrayList();
        for (List<SortedRun> section : sections) {
            readers.add(() -> MergeTreeReaders.readerForSection(section, readerFactory, userKeyComparator, new ReducerMergeFunctionWrapper(mergeFunction)));
        }
        DropDeleteReader reader = ConcatRecordReader.create(readers);
        if (dropDelete) {
            reader = new DropDeleteReader(reader);
        }
        return reader;
    }

    public static RecordReader<KeyValue> readerForSection(List<SortedRun> section, KeyValueFileReaderFactory readerFactory, Comparator<InternalRow> userKeyComparator, MergeFunctionWrapper<KeyValue> mergeFunctionWrapper) throws IOException {
        List<RecordReader<KeyValue>> readers = MergeTreeReaders.readerForSection(section, readerFactory);
        if (readers.size() == 1) {
            return readers.get(0);
        }
        return new SortMergeReader<KeyValue>(readers, userKeyComparator, mergeFunctionWrapper);
    }

    public static RecordReader<KeyValue> readerForRun(SortedRun run, KeyValueFileReaderFactory readerFactory) throws IOException {
        ArrayList readers = new ArrayList();
        for (DataFileMeta file : run.files()) {
            readers.add(() -> readerFactory.createRecordReader(file.schemaId(), file.fileName(), file.level()));
        }
        return ConcatRecordReader.create(readers);
    }

    public static List<RecordReader<KeyValue>> readerForSection(List<SortedRun> runs, KeyValueFileReaderFactory readerFactory) throws IOException {
        ArrayList<RecordReader<KeyValue>> readers = new ArrayList<RecordReader<KeyValue>>();
        try {
            for (SortedRun run : runs) {
                readers.add(MergeTreeReaders.readerForRun(run, readerFactory));
            }
        }
        catch (IOException e) {
            readers.forEach(IOUtils::closeQuietly);
            throw e;
        }
        return readers;
    }
}

