/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeTreeCompactRewriter;
import org.apache.paimon.mergetree.compact.SortMergeReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.reader.RecordReaderIterator;

public abstract class ChangelogMergeTreeRewriter
extends MergeTreeCompactRewriter {
    public ChangelogMergeTreeRewriter(KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory) {
        super(readerFactory, writerFactory, keyComparator, mfFactory);
    }

    protected abstract boolean rewriteChangelog(int var1, boolean var2, List<List<SortedRun>> var3);

    protected abstract boolean upgradeChangelog(int var1, DataFileMeta var2);

    protected abstract MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int var1);

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        if (this.rewriteChangelog(outputLevel, dropDelete, sections)) {
            return this.rewriteChangelogCompaction(outputLevel, sections);
        }
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompactResult rewriteChangelogCompaction(int outputLevel, List<List<SortedRun>> sections) throws Exception {
        ArrayList sectionReaders = new ArrayList();
        for (List<SortedRun> section : sections) {
            sectionReaders.add(() -> {
                List<RecordReader<KeyValue>> runReaders = MergeTreeReaders.readerForSection(section, this.readerFactory);
                return new SortMergeReader<ChangelogResult>(runReaders, this.keyComparator, this.createMergeWrapper(outputLevel));
            });
        }
        RecordReaderIterator iterator = null;
        RollingFileWriter<KeyValue, DataFileMeta> compactFileWriter = null;
        RollingFileWriter<KeyValue, DataFileMeta> changelogFileWriter = null;
        try {
            iterator = new RecordReaderIterator(ConcatRecordReader.create(sectionReaders));
            compactFileWriter = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
            changelogFileWriter = this.writerFactory.createRollingChangelogFileWriter(outputLevel);
            while (iterator.hasNext()) {
                ChangelogResult result = (ChangelogResult)iterator.next();
                if (result.result() != null) {
                    compactFileWriter.write(result.result());
                }
                for (KeyValue kv : result.changelogs()) {
                    changelogFileWriter.write(kv);
                }
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
            if (compactFileWriter != null) {
                compactFileWriter.close();
            }
            if (changelogFileWriter != null) {
                changelogFileWriter.close();
            }
        }
        return new CompactResult(ChangelogMergeTreeRewriter.extractFilesFromSections(sections), (List<DataFileMeta>)compactFileWriter.result(), (List<DataFileMeta>)changelogFileWriter.result());
    }

    @Override
    public CompactResult upgrade(int outputLevel, DataFileMeta file) throws Exception {
        if (this.upgradeChangelog(outputLevel, file)) {
            return this.rewriteChangelogCompaction(outputLevel, Collections.singletonList(Collections.singletonList(SortedRun.fromSingle(file))));
        }
        return super.upgrade(outputLevel, file);
    }
}

