/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;

public class LookupMergeFunction
implements MergeFunction<KeyValue> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final LinkedList<KeyValue> candidates = new LinkedList();
    KeyValue highLevel;
    boolean containLevel0;

    public LookupMergeFunction(MergeFunction<KeyValue> mergeFunction) {
        this.mergeFunction = mergeFunction;
    }

    @Override
    public void reset() {
        this.candidates.clear();
        this.highLevel = null;
        this.containLevel0 = false;
    }

    @Override
    public void add(KeyValue kv) {
        this.candidates.add(kv);
    }

    @Override
    public KeyValue getResult() {
        Iterator<KeyValue> descending = this.candidates.descendingIterator();
        while (descending.hasNext()) {
            KeyValue kv = descending.next();
            if (kv.level() > 0) {
                if (this.highLevel != null) {
                    descending.remove();
                    continue;
                }
                this.highLevel = kv;
                continue;
            }
            this.containLevel0 = true;
        }
        this.mergeFunction.reset();
        this.candidates.forEach(this.mergeFunction::add);
        return this.mergeFunction.getResult();
    }

    public static MergeFunctionFactory<KeyValue> wrap(MergeFunctionFactory<KeyValue> wrapped) {
        return new Factory(wrapped);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final MergeFunctionFactory<KeyValue> wrapped;

        private Factory(MergeFunctionFactory<KeyValue> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new LookupMergeFunction(this.wrapped.create(projection));
        }
    }
}

