/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactFutureManager;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.compact.CompactRewriter;
import org.apache.paimon.mergetree.compact.CompactStrategy;
import org.apache.paimon.mergetree.compact.MergeTreeCompactTask;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTreeCompactManager
extends CompactFutureManager {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTreeCompactManager.class);
    private final ExecutorService executor;
    private final Levels levels;
    private final CompactStrategy strategy;
    private final Comparator<InternalRow> keyComparator;
    private final long minFileSize;
    private final int numSortedRunStopTrigger;
    private final CompactRewriter rewriter;

    public MergeTreeCompactManager(ExecutorService executor, Levels levels, CompactStrategy strategy, Comparator<InternalRow> keyComparator, long minFileSize, int numSortedRunStopTrigger, CompactRewriter rewriter) {
        this.executor = executor;
        this.levels = levels;
        this.strategy = strategy;
        this.minFileSize = minFileSize;
        this.numSortedRunStopTrigger = numSortedRunStopTrigger;
        this.keyComparator = keyComparator;
        this.rewriter = rewriter;
    }

    @Override
    public boolean shouldWaitCompaction() {
        return this.levels.numberOfSortedRuns() > this.numSortedRunStopTrigger;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
        this.levels.addLevel0File(file);
    }

    public List<DataFileMeta> allFiles() {
        return this.levels.allFiles();
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        Optional<CompactUnit> optionalUnit;
        List<LevelSortedRun> runs = this.levels.levelSortedRuns();
        if (fullCompaction) {
            Preconditions.checkState(this.taskFuture == null, "A compaction task is still running while the user forces a new compaction. This is unexpected.");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trigger forced full compaciton. Picking from the following runs\n{}", runs);
            }
            optionalUnit = CompactStrategy.pickFullCompaction(this.levels.numberOfLevels(), runs);
        } else {
            if (this.taskFuture != null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trigger normal compaciton. Picking from the following runs\n{}", runs);
            }
            optionalUnit = this.strategy.pick(this.levels.numberOfLevels(), runs).filter(unit -> unit.files().size() > 0).filter(unit -> unit.files().size() > 1 || unit.files().get(0).level() != unit.outputLevel());
        }
        optionalUnit.ifPresent(unit -> {
            boolean dropDelete;
            boolean bl = dropDelete = unit.outputLevel() != 0 && unit.outputLevel() >= this.levels.nonEmptyHighestLevel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submit compaction with files (name, level, size): " + this.levels.levelSortedRuns().stream().flatMap(lsr -> lsr.run().files().stream()).map(file -> String.format("(%s, %d, %d)", file.fileName(), file.level(), file.fileSize())).collect(Collectors.joining(", ")));
            }
            this.submitCompaction((CompactUnit)unit, dropDelete);
        });
    }

    @VisibleForTesting
    public Levels levels() {
        return this.levels;
    }

    private void submitCompaction(CompactUnit unit, boolean dropDelete) {
        MergeTreeCompactTask task = new MergeTreeCompactTask(this.keyComparator, this.minFileSize, this.rewriter, unit, dropDelete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pick these files (name, level, size) for compaction: {}", (Object)unit.files().stream().map(file -> String.format("(%s, %d, %d)", file.fileName(), file.level(), file.fileSize())).collect(Collectors.joining(", ")));
        }
        this.taskFuture = this.executor.submit(task);
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        Optional<CompactResult> result = this.innerGetCompactionResult(blocking);
        result.ifPresent(r -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Update levels in compact manager with these changes:\nBefore:\n{}\nAfter:\n{}", r.before(), r.after());
            }
            this.levels.update(r.before(), r.after());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Levels in compact manager updated. Current runs are\n{}", this.levels.levelSortedRuns());
            }
        });
        return result;
    }

    @Override
    public void close() throws IOException {
        this.rewriter.close();
    }
}

