/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.AbstractCompactRewriter;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.reader.RecordReaderIterator;

public class MergeTreeCompactRewriter
extends AbstractCompactRewriter {
    protected final KeyValueFileReaderFactory readerFactory;
    protected final KeyValueFileWriterFactory writerFactory;
    protected final Comparator<InternalRow> keyComparator;
    protected final MergeFunctionFactory<KeyValue> mfFactory;

    public MergeTreeCompactRewriter(KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.keyComparator = keyComparator;
        this.mfFactory = mfFactory;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    protected CompactResult rewriteCompaction(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        RollingFileWriter<KeyValue, DataFileMeta> writer = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
        RecordReader<KeyValue> sectionsReader = MergeTreeReaders.readerForMergeTree(sections, dropDelete, this.readerFactory, this.keyComparator, this.mfFactory.create());
        writer.write((KeyValue)((Object)new RecordReaderIterator<KeyValue>(sectionsReader)));
        writer.close();
        return new CompactResult(MergeTreeCompactRewriter.extractFilesFromSections(sections), (List<DataFileMeta>)writer.result());
    }
}

