/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Projection;

public class PartialUpdateMergeFunction
implements MergeFunction<KeyValue> {
    private final InternalRow.FieldGetter[] getters;
    private final boolean ignoreDelete;
    private KeyValue latestKv;
    private GenericRow row;
    private KeyValue reused;

    protected PartialUpdateMergeFunction(InternalRow.FieldGetter[] getters, boolean ignoreDelete) {
        this.getters = getters;
        this.ignoreDelete = ignoreDelete;
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.row = new GenericRow(this.getters.length);
    }

    @Override
    public void add(KeyValue kv) {
        if (kv.valueKind() == RowKind.UPDATE_BEFORE || kv.valueKind() == RowKind.DELETE) {
            if (this.ignoreDelete) {
                return;
            }
            if (kv.valueKind() == RowKind.UPDATE_BEFORE) {
                throw new IllegalArgumentException("Partial update can not accept update_before records, it is a bug.");
            }
            throw new IllegalArgumentException("Partial update can not accept delete records. Partial delete is not supported!");
        }
        this.latestKv = kv;
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(kv.value());
            if (field == null) continue;
            this.row.setField(i, field);
        }
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        if (this.latestKv == null) {
            if (this.ignoreDelete) {
                return null;
            }
            throw new IllegalArgumentException("Trying to get result from merge function without any input. This is unexpected.");
        }
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), RowKind.INSERT, this.row);
    }

    public static MergeFunctionFactory<KeyValue> factory(boolean ignoreDelete, List<DataType> tableTypes) {
        return new Factory(ignoreDelete, tableTypes);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final boolean ignoreDelete;
        private final List<DataType> tableTypes;

        private Factory(boolean ignoreDelete, List<DataType> tableTypes) {
            this.ignoreDelete = ignoreDelete;
            this.tableTypes = tableTypes;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            List<DataType> fieldTypes = this.tableTypes;
            if (projection != null) {
                fieldTypes = Projection.of(projection).project(this.tableTypes);
            }
            return new PartialUpdateMergeFunction(InternalRowUtils.createFieldGetters(fieldTypes), this.ignoreDelete);
        }
    }
}

