/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final RowType rowType;
    private final FieldStatsConverters fieldStatsConverters;
    private Predicate filter;

    public AppendOnlyFileStoreScan(RowType partitionType, RowType bucketKeyType, RowType rowType, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        super(partitionType, bucketKeyType, snapshotManager, schemaManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets);
        this.rowType = rowType;
        this.fieldStatsConverters = new FieldStatsConverters(sid -> this.scanTableSchema((long)sid).fields(), schemaId);
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.filter = predicate;
        List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.rowType.getFieldNames(), this.bucketKeyType.getFieldNames());
        if (bucketFilters.size() > 0) {
            this.withBucketKeyFilter(PredicateBuilder.and(bucketFilters));
        }
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.filter == null || this.filter.test(entry.file().rowCount(), entry.file().valueStats().fields(this.fieldStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()));
    }
}

