/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.AppendOnlyCompactManager;
import org.apache.paimon.append.AppendOnlyWriter;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.NoopCompactManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.AppendOnlyFileStoreRead;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreWrite
extends AbstractFileStoreWrite<InternalRow> {
    private final FileIO fileIO;
    private final AppendOnlyFileStoreRead read;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final long targetFileSize;
    private final int compactionMinFileNum;
    private final int compactionMaxFileNum;
    private final boolean commitForceCompact;
    private final boolean skipCompaction;
    private final boolean assertDisorder;
    private final String fileCompression;

    public AppendOnlyFileStoreWrite(FileIO fileIO, AppendOnlyFileStoreRead read, long schemaId, String commitUser, RowType rowType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options) {
        super(commitUser, snapshotManager, scan);
        this.fileIO = fileIO;
        this.read = read;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = options.fileFormat();
        this.pathFactory = pathFactory;
        this.targetFileSize = options.targetFileSize();
        this.compactionMinFileNum = options.compactionMinFileNum();
        this.compactionMaxFileNum = options.compactionMaxFileNum();
        this.commitForceCompact = options.commitForceCompact();
        this.skipCompaction = options.writeOnly();
        this.assertDisorder = options.toConfiguration().get(CoreOptions.APPEND_ONLY_ASSERT_DISORDER);
        this.fileCompression = options.fileCompression();
    }

    @Override
    protected RecordWriter<InternalRow> createWriter(BinaryRow partition, int bucket, List<DataFileMeta> restoredFiles, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor) {
        long maxSequenceNumber = DataFileMeta.getMaxSequenceNumber(restoredFiles);
        DataFilePathFactory factory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        CompactManager compactManager = this.skipCompaction ? new NoopCompactManager() : new AppendOnlyCompactManager(compactExecutor, restoredFiles, this.compactionMinFileNum, this.compactionMaxFileNum, this.targetFileSize, this.compactRewriter(partition, bucket), this.assertDisorder);
        return new AppendOnlyWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, maxSequenceNumber, compactManager, this.commitForceCompact, factory, restoreIncrement, this.fileCompression);
    }

    private AppendOnlyCompactManager.CompactRewriter compactRewriter(BinaryRow partition, int bucket) {
        return toCompact -> {
            if (toCompact.isEmpty()) {
                return Collections.emptyList();
            }
            RowDataRollingFileWriter rewriter = new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, this.pathFactory.createDataFilePathFactory(partition, bucket), new LongCounter(((DataFileMeta)toCompact.get(0)).minSequenceNumber()), this.fileCompression);
            rewriter.write(new RecordReaderIterator<InternalRow>(this.read.createReader(new DataSplit(0L, partition, bucket, toCompact, false))));
            rewriter.close();
            return rewriter.result();
        };
    }
}

