/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileStoreExpire;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterables;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreExpireImpl
implements FileStoreExpire {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreExpireImpl.class);
    private final FileIO fileIO;
    private final int numRetainedMin;
    private final int numRetainedMax;
    private final long millisRetained;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final ManifestFile manifestFile;
    private final ManifestList manifestList;
    private Lock lock;

    public FileStoreExpireImpl(FileIO fileIO, int numRetainedMin, int numRetainedMax, long millisRetained, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory) {
        this.fileIO = fileIO;
        this.numRetainedMin = numRetainedMin;
        this.numRetainedMax = numRetainedMax;
        this.millisRetained = millisRetained;
        this.pathFactory = pathFactory;
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.manifestFile = manifestFileFactory.create();
        this.manifestList = manifestListFactory.create();
    }

    @Override
    public FileStoreExpire withLock(Lock lock) {
        this.lock = lock;
        return this;
    }

    @Override
    public void expire() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return;
        }
        long currentMillis = System.currentTimeMillis();
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return;
        }
        for (long id = Math.max(latestSnapshotId - (long)this.numRetainedMax + 1L, earliest); id <= latestSnapshotId - (long)this.numRetainedMin; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || currentMillis - this.snapshotManager.snapshot(id).timeMillis() > this.millisRetained) continue;
            this.expireUntil(earliest, id);
            return;
        }
        this.expireUntil(earliest, latestSnapshotId - (long)this.numRetainedMin + 1L);
    }

    private void expireUntil(long earliestId, long endExclusiveId) {
        Snapshot snapshot;
        long id;
        OptionalLong minNextSnapshot = this.consumerManager.minNextSnapshot();
        if (minNextSnapshot.isPresent()) {
            endExclusiveId = Math.min(minNextSnapshot.getAsLong(), endExclusiveId);
        }
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.readHint("EARLIEST") == null) {
                this.writeEarliestHint(endExclusiveId);
            }
            return;
        }
        long beginInclusiveId = earliestId;
        for (long id2 = endExclusiveId - 1L; id2 >= earliestId; --id2) {
            if (this.snapshotManager.snapshotExists(id2)) continue;
            beginInclusiveId = id2 + 1L;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
        }
        HashMap<BinaryRow, Set<Integer>> changedBuckets = new HashMap<BinaryRow, Set<Integer>>();
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
            }
            snapshot = this.snapshotManager.snapshot(id);
            this.expireMergeTreeFiles(snapshot.deltaManifestList()).forEach((partition, buckets) -> changedBuckets.computeIfAbsent((BinaryRow)partition, p -> new HashSet()).addAll(buckets));
        }
        for (id = beginInclusiveId; id < endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from snapshot #" + id);
            }
            if ((snapshot = this.snapshotManager.snapshot(id)).changelogManifestList() == null) continue;
            this.expireChangelogFiles(snapshot.changelogManifestList());
        }
        this.tryDeleteDirectories(changedBuckets);
        Snapshot exclusiveSnapshot = this.snapshotManager.snapshot(endExclusiveId);
        HashSet<ManifestFileMeta> manifestsInUse = new HashSet<ManifestFileMeta>(exclusiveSnapshot.dataManifests(this.manifestList));
        HashSet<ManifestFileMeta> deletedManifests = new HashSet<ManifestFileMeta>();
        for (long id3 = beginInclusiveId; id3 < endExclusiveId; ++id3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id3);
            }
            Snapshot toExpire = this.snapshotManager.snapshot(id3);
            ArrayList<ManifestFileMeta> toExpireManifests = new ArrayList<ManifestFileMeta>();
            toExpireManifests.addAll(this.tryReadManifestList(toExpire.baseManifestList()));
            toExpireManifests.addAll(this.tryReadManifestList(toExpire.deltaManifestList()));
            for (ManifestFileMeta manifest : toExpireManifests) {
                if (manifestsInUse.contains(manifest) || deletedManifests.contains(manifest)) continue;
                this.manifestFile.delete(manifest.fileName());
                deletedManifests.add(manifest);
            }
            if (toExpire.changelogManifestList() != null) {
                for (ManifestFileMeta manifest : this.tryReadManifestList(toExpire.changelogManifestList())) {
                    this.manifestFile.delete(manifest.fileName());
                }
            }
            this.manifestList.delete(toExpire.baseManifestList());
            this.manifestList.delete(toExpire.deltaManifestList());
            if (toExpire.changelogManifestList() != null) {
                this.manifestList.delete(toExpire.changelogManifestList());
            }
            this.fileIO.deleteQuietly(this.snapshotManager.snapshotPath(id3));
        }
        this.writeEarliestHint(endExclusiveId);
    }

    private Map<BinaryRow, Set<Integer>> expireMergeTreeFiles(String manifestListName) {
        return this.expireMergeTreeFiles(this.getManifestEntriesFromManifestList(manifestListName));
    }

    @VisibleForTesting
    Map<BinaryRow, Set<Integer>> expireMergeTreeFiles(Iterable<ManifestEntry> dataFileLog) {
        HashMap<Path, Triple> dataFileToDelete = new HashMap<Path, Triple>();
        block4: for (ManifestEntry entry : dataFileLog) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, Triple.of(entry.partition(), entry.bucket(), extraFiles));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
        HashMap<BinaryRow, Set<Integer>> changedBuckets = new HashMap<BinaryRow, Set<Integer>>();
        dataFileToDelete.forEach((path, triple) -> {
            this.fileIO.deleteQuietly((Path)path);
            ((List)triple.f2).forEach(this.fileIO::deleteQuietly);
            changedBuckets.computeIfAbsent((BinaryRow)triple.f0, p -> new HashSet()).add(triple.f1);
        });
        return changedBuckets;
    }

    private void expireChangelogFiles(String manifestListName) {
        for (ManifestEntry changelogEntry : this.getManifestEntriesFromManifestList(manifestListName)) {
            this.fileIO.deleteQuietly(new Path(this.pathFactory.bucketPath(changelogEntry.partition(), changelogEntry.bucket()), changelogEntry.file().fileName()));
        }
    }

    private Iterable<ManifestEntry> getManifestEntriesFromManifestList(String manifestListName) {
        List manifestFiles = this.tryReadManifestList(manifestListName).stream().map(ManifestFileMeta::fileName).collect(Collectors.toList());
        final LinkedList files = new LinkedList(manifestFiles);
        return Iterables.concat(() -> new Iterator<Iterable<ManifestEntry>>(){

            @Override
            public boolean hasNext() {
                return files.size() > 0;
            }

            @Override
            public Iterable<ManifestEntry> next() {
                String file = (String)files.poll();
                try {
                    return FileStoreExpireImpl.this.manifestFile.read(file);
                }
                catch (Exception e) {
                    LOG.warn("Failed to read manifest file " + file, (Throwable)e);
                    return Collections.emptyList();
                }
            }
        });
    }

    private List<ManifestFileMeta> tryReadManifestList(String manifestListName) {
        try {
            return this.manifestList.read(manifestListName);
        }
        catch (Exception e) {
            LOG.warn("Failed to read manifest list file " + manifestListName, (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void writeEarliestHint(long earliest) {
        Callable<Void> callable = () -> {
            this.snapshotManager.commitEarliestHint(earliest);
            return null;
        };
        try {
            if (this.lock != null) {
                this.lock.runWithLock(callable);
            } else {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void tryDeleteDirectories(Map<BinaryRow, Set<Integer>> changedBuckets) {
        HashMap<Integer, Set> deduplicate = new HashMap<Integer, Set>();
        for (Map.Entry<BinaryRow, Set<Integer>> entry : changedBuckets.entrySet()) {
            for (Integer bucket : entry.getValue()) {
                this.tryDeleteEmptyDirectory(this.pathFactory.bucketPath(entry.getKey(), bucket));
            }
            List<Path> hierarchicalPaths = this.pathFactory.getHierarchicalPartitionPath(entry.getKey());
            int hierarchies = hierarchicalPaths.size();
            if (hierarchies == 0 || !this.tryDeleteEmptyDirectory(hierarchicalPaths.get(hierarchies - 1))) continue;
            for (int hierarchy = 0; hierarchy < hierarchies - 1; ++hierarchy) {
                Path path = hierarchicalPaths.get(hierarchy);
                deduplicate.computeIfAbsent(hierarchy, i -> new HashSet()).add(path);
            }
        }
        for (int hierarchy = deduplicate.size() - 1; hierarchy >= 0; --hierarchy) {
            ((Set)deduplicate.get(hierarchy)).forEach(this::tryDeleteEmptyDirectory);
        }
    }

    private boolean tryDeleteEmptyDirectory(Path path) {
        try {
            this.fileIO.delete(path, false);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Failed to delete directory '{}'. Check whether it is empty.", (Object)path);
            return false;
        }
    }
}

