/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.mergetree.DropDeleteReader;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.IntervalPartition;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.operation.FileStoreRead;
import org.apache.paimon.operation.ReverseReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ProjectedRow;

public class KeyValueFileStoreRead
implements FileStoreRead<KeyValue> {
    private final TableSchema tableSchema;
    private final KeyValueFileReaderFactory.Builder readerFactoryBuilder;
    private final Comparator<InternalRow> keyComparator;
    private final MergeFunctionFactory<KeyValue> mfFactory;
    private final boolean valueCountMode;
    @Nullable
    private int[][] keyProjectedFields;
    @Nullable
    private List<Predicate> filtersForOverlappedSection;
    @Nullable
    private List<Predicate> filtersForNonOverlappedSection;
    @Nullable
    private int[][] valueProjection;

    public KeyValueFileStoreRead(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor) {
        this.tableSchema = schemaManager.schema(schemaId);
        this.readerFactoryBuilder = KeyValueFileReaderFactory.builder(fileIO, schemaManager, schemaId, keyType, valueType, formatDiscover, pathFactory, extractor);
        this.keyComparator = keyComparator;
        this.mfFactory = mfFactory;
        this.valueCountMode = this.tableSchema.trimmedPrimaryKeys().isEmpty();
    }

    public KeyValueFileStoreRead withKeyProjection(int[][] projectedFields) {
        this.readerFactoryBuilder.withKeyProjection(projectedFields);
        this.keyProjectedFields = projectedFields;
        return this;
    }

    public KeyValueFileStoreRead withValueProjection(int[][] projectedFields) {
        this.valueProjection = projectedFields;
        this.readerFactoryBuilder.withValueProjection(projectedFields);
        return this;
    }

    @Override
    public FileStoreRead<KeyValue> withFilter(Predicate predicate) {
        ArrayList<Predicate> allFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> pkFilters = null;
        List<String> primaryKeys = this.tableSchema.trimmedPrimaryKeys();
        Set<String> nonPrimaryKeys = this.tableSchema.fieldNames().stream().filter(name -> !primaryKeys.contains(name)).collect(Collectors.toSet());
        for (Predicate sub : PredicateBuilder.splitAnd(predicate)) {
            allFilters.add(sub);
            if (PredicateBuilder.containsFields(sub, nonPrimaryKeys)) continue;
            if (pkFilters == null) {
                pkFilters = new ArrayList<Predicate>();
            }
            pkFilters.add(sub);
        }
        this.filtersForNonOverlappedSection = allFilters;
        this.filtersForOverlappedSection = this.valueCountMode ? allFilters : pkFilters;
        return this;
    }

    @Override
    public RecordReader<KeyValue> createReader(DataSplit split) throws IOException {
        if (split.isIncremental()) {
            KeyValueFileReaderFactory readerFactory = this.readerFactoryBuilder.build(split.partition(), split.bucket(), true, this.filtersForOverlappedSection);
            ArrayList suppliers = new ArrayList();
            for (DataFileMeta file : split.files()) {
                suppliers.add(() -> {
                    String fileName = this.changelogFile(file).orElse(file.fileName());
                    return readerFactory.createRecordReader(file.schemaId(), fileName, file.level());
                });
            }
            ReverseReader concatRecordReader = ConcatRecordReader.create(suppliers);
            return split.reverseRowKind() ? new ReverseReader(concatRecordReader) : concatRecordReader;
        }
        KeyValueFileReaderFactory overlappedSectionFactory = this.readerFactoryBuilder.build(split.partition(), split.bucket(), false, this.filtersForOverlappedSection);
        KeyValueFileReaderFactory nonOverlappedSectionFactory = this.readerFactoryBuilder.build(split.partition(), split.bucket(), false, this.filtersForNonOverlappedSection);
        ArrayList sectionReaders = new ArrayList();
        ReducerMergeFunctionWrapper mergeFuncWrapper = new ReducerMergeFunctionWrapper(this.mfFactory.create(this.valueProjection));
        for (List<SortedRun> section : new IntervalPartition(split.files(), this.keyComparator).partition()) {
            sectionReaders.add(() -> MergeTreeReaders.readerForSection(section, section.size() > 1 ? overlappedSectionFactory : nonOverlappedSectionFactory, this.keyComparator, mergeFuncWrapper));
        }
        DropDeleteReader reader = new DropDeleteReader(ConcatRecordReader.create(sectionReaders));
        return this.keyProjectedFields == null ? reader : this.projectKey(reader, this.keyProjectedFields);
    }

    private Optional<String> changelogFile(DataFileMeta fileMeta) {
        for (String file : fileMeta.extraFiles()) {
            if (!file.startsWith("changelog-")) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private RecordReader<KeyValue> projectKey(RecordReader<KeyValue> reader, int[][] keyProjectedFields) {
        ProjectedRow projectedRow = ProjectedRow.from(keyProjectedFields);
        return reader.transform(kv -> kv.replaceKey(projectedRow.replaceRow(kv.key())));
    }
}

