/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsConverters fieldStatsConverters;
    private final RowType keyType;
    private Predicate keyFilter;

    public KeyValueFileStoreScan(RowType partitionType, RowType bucketKeyType, RowType keyType, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        super(partitionType, bucketKeyType, snapshotManager, schemaManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets);
        this.fieldStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.keyFields(this.scanTableSchema((long)sid)), schemaId);
        this.keyType = keyType;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.keyType.getFieldNames(), this.bucketKeyType.getFieldNames());
        if (bucketFilters.size() > 0) {
            this.withBucketKeyFilter(PredicateBuilder.and(bucketFilters));
        }
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.keyFilter == null || this.keyFilter.test(entry.file().rowCount(), entry.file().keyStats().fields(this.fieldStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()));
    }
}

