/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.Iterator;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;

public abstract class MemoryFileStoreWrite<T>
extends AbstractFileStoreWrite<T> {
    private final MemoryPoolFactory writeBufferPool;
    protected final CacheManager cacheManager;

    public MemoryFileStoreWrite(String commitUser, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options) {
        super(commitUser, snapshotManager, scan);
        HeapMemorySegmentPool memoryPool = new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize());
        this.writeBufferPool = new MemoryPoolFactory(memoryPool, this::memoryOwners);
        this.cacheManager = new CacheManager(options.pageSize(), options.toConfiguration().get(CoreOptions.LOOKUP_CACHE_MAX_MEMORY_SIZE));
    }

    private Iterator<MemoryOwner> memoryOwners() {
        final Iterator iterator = this.writers.values().iterator();
        return Iterators.concat(new Iterator<Iterator<MemoryOwner>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<MemoryOwner> next() {
                return Iterators.transform(((Map)iterator.next()).values().iterator(), writerContainer -> writerContainer == null ? null : (MemoryOwner)((Object)writerContainer.writer));
            }
        });
    }

    @Override
    protected void notifyNewWriter(RecordWriter<T> writer) {
        if (!(writer instanceof MemoryOwner)) {
            throw new RuntimeException("Should create a MemoryOwner for MemoryTableWrite, but this is: " + writer.getClass());
        }
        this.writeBufferPool.notifyNewOwner((MemoryOwner)((Object)writer));
    }
}

