/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public class PartitionTimeExtractor {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    @Nullable
    private final String pattern;
    @Nullable
    private final String formatter;

    public PartitionTimeExtractor(@Nullable String pattern, @Nullable String formatter) {
        this.pattern = pattern;
        this.formatter = formatter;
    }

    public LocalDateTime extract(List<String> partitionKeys, List<Object> partitionValues) {
        String timestampString;
        if (this.pattern == null) {
            timestampString = partitionValues.get(0).toString();
        } else {
            timestampString = this.pattern;
            for (int i = 0; i < partitionKeys.size(); ++i) {
                timestampString = timestampString.replaceAll("\\$" + partitionKeys.get(i), partitionValues.get(i).toString());
            }
        }
        return PartitionTimeExtractor.toLocalDateTime(timestampString, this.formatter);
    }

    private static LocalDateTime toLocalDateTime(String timestampString, @Nullable String formatterPattern) {
        if (formatterPattern == null) {
            return PartitionTimeExtractor.toLocalDateTimeDefault(timestampString);
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(Objects.requireNonNull(formatterPattern), Locale.ROOT);
        try {
            return LocalDateTime.parse(timestampString, Objects.requireNonNull(dateTimeFormatter));
        }
        catch (DateTimeParseException e) {
            return LocalDateTime.of(LocalDate.parse(timestampString, Objects.requireNonNull(dateTimeFormatter)), LocalTime.MIDNIGHT);
        }
    }

    public static LocalDateTime toLocalDateTimeDefault(String timestampString) {
        try {
            return LocalDateTime.parse(timestampString, TIMESTAMP_FORMATTER);
        }
        catch (DateTimeParseException e) {
            return LocalDateTime.of(LocalDate.parse(timestampString, DATE_FORMATTER), LocalTime.MIDNIGHT);
        }
    }
}

