/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

@Public
public class Schema {
    private final List<DataField> fields;
    private final List<String> partitionKeys;
    private final List<String> primaryKeys;
    private final Map<String, String> options;
    private final String comment;

    public Schema(List<DataField> fields, List<String> partitionKeys, List<String> primaryKeys, Map<String, String> options, String comment) {
        this.fields = Schema.normalizeFields(fields, primaryKeys, partitionKeys);
        this.partitionKeys = partitionKeys;
        this.primaryKeys = primaryKeys;
        this.options = new HashMap<String, String>(options);
        this.comment = comment;
    }

    public RowType rowType() {
        return new RowType(false, this.fields);
    }

    public List<DataField> fields() {
        return this.fields;
    }

    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public String comment() {
        return this.comment;
    }

    private static List<DataField> normalizeFields(List<DataField> fields, List<String> primaryKeys, List<String> partitionKeys) {
        List<String> fieldNames = fields.stream().map(DataField::name).collect(Collectors.toList());
        Set<String> duplicateColumns = Schema.duplicate(fieldNames);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Table column %s must not contain duplicate fields. Found: %s", fieldNames, duplicateColumns);
        HashSet<String> allFields = new HashSet<String>(fieldNames);
        duplicateColumns = Schema.duplicate(partitionKeys);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Partition key constraint %s must not contain duplicate columns. Found: %s", partitionKeys, duplicateColumns);
        Preconditions.checkState(allFields.containsAll(partitionKeys), "Table column %s should include all partition fields %s", fieldNames, partitionKeys);
        if (primaryKeys.isEmpty()) {
            return fields;
        }
        duplicateColumns = Schema.duplicate(primaryKeys);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Primary key constraint %s must not contain duplicate columns. Found: %s", primaryKeys, duplicateColumns);
        Preconditions.checkState(allFields.containsAll(primaryKeys), "Table column %s should include all primary key constraint %s", fieldNames, primaryKeys);
        HashSet<String> pkSet = new HashSet<String>(primaryKeys);
        Preconditions.checkState(pkSet.containsAll(partitionKeys), "Primary key constraint %s should include all partition fields %s", primaryKeys, partitionKeys);
        ArrayList<DataField> newFields = new ArrayList<DataField>();
        for (DataField field : fields) {
            if (pkSet.contains(field.name()) && field.type().isNullable()) {
                newFields.add(new DataField(field.id(), field.name(), field.type().copy(false), field.description()));
                continue;
            }
            newFields.add(field);
        }
        return newFields;
    }

    private static Set<String> duplicate(List<String> names) {
        return names.stream().filter(name -> Collections.frequency(names, name) > 1).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema that = (Schema)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.primaryKeys, that.primaryKeys) && Objects.equals(this.options, that.options) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.partitionKeys, this.primaryKeys, this.options, this.comment);
    }

    public String toString() {
        return "UpdateSchema{fields=" + this.fields + ", partitionKeys=" + this.partitionKeys + ", primaryKeys=" + this.primaryKeys + ", options=" + this.options + ", comment=" + this.comment + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<DataField> columns = new ArrayList<DataField>();
        private List<String> partitionKeys = new ArrayList<String>();
        private List<String> primaryKeys = new ArrayList<String>();
        private final Map<String, String> options = new HashMap<String, String>();
        @Nullable
        private String comment;
        private int highestFieldId = -1;

        public int getHighestFieldId() {
            return this.highestFieldId;
        }

        public Builder column(String columnName, DataType dataType) {
            return this.column(columnName, dataType, null);
        }

        public Builder column(String columnName, DataType dataType, @Nullable String description) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(dataType, "Data type must not be null.");
            this.columns.add(new DataField(++this.highestFieldId, columnName, dataType, description));
            return this;
        }

        public Builder partitionKeys(String ... columnNames) {
            return this.partitionKeys(Arrays.asList(columnNames));
        }

        public Builder partitionKeys(List<String> columnNames) {
            this.partitionKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder primaryKey(String ... columnNames) {
            return this.primaryKey(Arrays.asList(columnNames));
        }

        public Builder primaryKey(List<String> columnNames) {
            this.primaryKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Schema build() {
            return new Schema(this.columns, this.partitionKeys, this.primaryKeys, this.options, this.comment);
        }
    }
}

