/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.ReassignFieldId;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.Preconditions;

public class SchemaManager
implements Serializable {
    private static final String SCHEMA_PREFIX = "schema-";
    private final FileIO fileIO;
    private final Path tableRoot;
    @Nullable
    private transient Lock lock;

    public SchemaManager(FileIO fileIO, Path tableRoot) {
        this.fileIO = fileIO;
        this.tableRoot = tableRoot;
    }

    public SchemaManager withLock(@Nullable Lock lock) {
        this.lock = lock;
        return this;
    }

    public Optional<TableSchema> latest() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::max).map(this::schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<TableSchema> listAll() {
        return this.listAllIds().stream().map(this::schema).collect(Collectors.toList());
    }

    public List<Long> listAllIds() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema createTable(Schema schema) throws Exception {
        Map<String, String> options;
        List<String> primaryKeys;
        List<String> partitionKeys;
        int highestFieldId;
        List<DataField> fields;
        TableSchema newSchema;
        boolean success;
        do {
            boolean exists;
            this.latest().ifPresent(latest -> {
                throw new IllegalStateException("Schema in filesystem exists, please use updating, latest schema is: " + this.latest());
            });
            fields = schema.fields();
            partitionKeys = schema.partitionKeys();
            primaryKeys = schema.primaryKeys();
            options = schema.options();
            highestFieldId = RowType.currentHighestFieldId(fields);
            List columnNames = schema.fields().stream().map(DataField::name).collect(Collectors.toList());
            if (options.containsKey(CoreOptions.PRIMARY_KEY.key())) {
                if (!primaryKeys.isEmpty()) {
                    throw new RuntimeException("Cannot define primary key on DDL and table options at the same time.");
                }
                String pk = options.get(CoreOptions.PRIMARY_KEY.key());
                primaryKeys = Arrays.asList(pk.split(","));
                exists = primaryKeys.stream().allMatch(columnNames::contains);
                if (!exists) {
                    throw new RuntimeException(String.format("Primary key column '%s' is not defined in the schema.", primaryKeys));
                }
                options.remove(CoreOptions.PRIMARY_KEY.key());
            }
            if (!options.containsKey(CoreOptions.PARTITION.key())) continue;
            if (!partitionKeys.isEmpty()) {
                throw new RuntimeException("Cannot define partition on DDL and table options at the same time.");
            }
            String partitions = options.get(CoreOptions.PARTITION.key());
            partitionKeys = Arrays.asList(partitions.split(","));
            exists = partitionKeys.stream().allMatch(columnNames::contains);
            if (!exists) {
                throw new RuntimeException(String.format("Partition column '%s' is not defined in the schema.", partitionKeys));
            }
            options.remove(CoreOptions.PARTITION.key());
        } while (!(success = this.commit(newSchema = new TableSchema(0L, fields, highestFieldId, partitionKeys, primaryKeys, options, schema.comment()))));
        return newSchema;
    }

    public TableSchema commitChanges(SchemaChange ... changes) throws Exception {
        return this.commitChanges(Arrays.asList(changes));
    }

    public TableSchema commitChanges(List<SchemaChange> changes) throws Exception {
        HashMap<String, String> newOptions;
        AtomicInteger highestFieldId;
        ArrayList<DataField> newFields;
        TableSchema schema;
        TableSchema newSchema;
        boolean success;
        do {
            schema = this.latest().orElseThrow(() -> new RuntimeException("Table not exists: " + this.tableRoot));
            newOptions = new HashMap<String, String>(schema.options());
            newFields = new ArrayList<DataField>(schema.fields());
            highestFieldId = new AtomicInteger(schema.highestFieldId());
            for (SchemaChange change : changes) {
                SchemaChange update;
                SchemaChange.Move move;
                if (change instanceof SchemaChange.SetOption) {
                    SchemaChange.SetOption setOption = (SchemaChange.SetOption)change;
                    SchemaManager.checkAlterTableOption(setOption.key());
                    newOptions.put(setOption.key(), setOption.value());
                    continue;
                }
                if (change instanceof SchemaChange.RemoveOption) {
                    SchemaChange.RemoveOption removeOption = (SchemaChange.RemoveOption)change;
                    SchemaManager.checkAlterTableOption(removeOption.key());
                    newOptions.remove(removeOption.key());
                    continue;
                }
                if (change instanceof SchemaChange.AddColumn) {
                    SchemaChange.AddColumn addColumn = (SchemaChange.AddColumn)change;
                    move = addColumn.move();
                    if (newFields.stream().anyMatch(f -> f.name().equals(addColumn.fieldName()))) {
                        throw new IllegalArgumentException(String.format("The column [%s] exists in the table[%s].", addColumn.fieldName(), this.tableRoot));
                    }
                    Preconditions.checkArgument(addColumn.dataType().isNullable(), "ADD COLUMN cannot specify NOT NULL.");
                    int id = highestFieldId.incrementAndGet();
                    DataType dataType = ReassignFieldId.reassign(addColumn.dataType(), highestFieldId);
                    DataField dataField = new DataField(id, addColumn.fieldName(), dataType, addColumn.description());
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (int i = 0; i < newFields.size(); ++i) {
                        map.put(((DataField)newFields.get(i)).name(), i);
                    }
                    if (null != move) {
                        if (move.type().equals((Object)SchemaChange.Move.MoveType.FIRST)) {
                            newFields.add(0, dataField);
                            continue;
                        }
                        if (!move.type().equals((Object)SchemaChange.Move.MoveType.AFTER)) continue;
                        int fieldIndex = (Integer)map.get(move.referenceFieldName());
                        newFields.add(fieldIndex + 1, dataField);
                        continue;
                    }
                    newFields.add(dataField);
                    continue;
                }
                if (change instanceof SchemaChange.RenameColumn) {
                    SchemaChange.RenameColumn rename = (SchemaChange.RenameColumn)change;
                    this.validateNotPrimaryAndPartitionKey(schema, rename.fieldName());
                    if (newFields.stream().anyMatch(f -> f.name().equals(rename.newName()))) {
                        throw new IllegalArgumentException(String.format("The column [%s] exists in the table[%s].", rename.newName(), this.tableRoot));
                    }
                    this.updateNestedColumn(newFields, new String[]{rename.fieldName()}, 0, field -> new DataField(field.id(), rename.newName(), field.type(), field.description()));
                    continue;
                }
                if (change instanceof SchemaChange.DropColumn) {
                    SchemaChange.DropColumn drop = (SchemaChange.DropColumn)change;
                    this.validateNotPrimaryAndPartitionKey(schema, drop.fieldName());
                    if (!newFields.removeIf(f -> f.name().equals(((SchemaChange.DropColumn)change).fieldName()))) {
                        throw new IllegalArgumentException(String.format("The column [%s] doesn't exist in the table[%s].", drop.fieldName(), this.tableRoot));
                    }
                    if (!newFields.isEmpty()) continue;
                    throw new IllegalArgumentException("Cannot drop all fields in table");
                }
                if (change instanceof SchemaChange.UpdateColumnType) {
                    update = (SchemaChange.UpdateColumnType)change;
                    if (schema.partitionKeys().contains(((SchemaChange.UpdateColumnType)update).fieldName())) {
                        throw new IllegalArgumentException(String.format("Cannot update partition column [%s] type in the table[%s].", ((SchemaChange.UpdateColumnType)update).fieldName(), this.tableRoot));
                    }
                    this.updateColumn(newFields, ((SchemaChange.UpdateColumnType)update).fieldName(), arg_0 -> SchemaManager.lambda$commitChanges$6((SchemaChange.UpdateColumnType)update, arg_0));
                    continue;
                }
                if (change instanceof SchemaChange.UpdateColumnNullability) {
                    update = (SchemaChange.UpdateColumnNullability)change;
                    if (((SchemaChange.UpdateColumnNullability)update).fieldNames().length == 1 && ((SchemaChange.UpdateColumnNullability)update).newNullability() && schema.primaryKeys().contains(((SchemaChange.UpdateColumnNullability)update).fieldNames()[0])) {
                        throw new UnsupportedOperationException("Cannot change nullability of primary key");
                    }
                    this.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnNullability)update).fieldNames(), 0, arg_0 -> SchemaManager.lambda$commitChanges$7((SchemaChange.UpdateColumnNullability)update, arg_0));
                    continue;
                }
                if (change instanceof SchemaChange.UpdateColumnComment) {
                    update = (SchemaChange.UpdateColumnComment)change;
                    this.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnComment)update).fieldNames(), 0, arg_0 -> SchemaManager.lambda$commitChanges$8((SchemaChange.UpdateColumnComment)update, arg_0));
                    continue;
                }
                if (change instanceof SchemaChange.UpdateColumnPosition) {
                    update = (SchemaChange.UpdateColumnPosition)change;
                    move = ((SchemaChange.UpdateColumnPosition)update).move();
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (int i = 0; i < newFields.size(); ++i) {
                        map.put(((DataField)newFields.get(i)).name(), i);
                    }
                    int fieldIndex = (Integer)map.get(move.fieldName());
                    int refIndex = 0;
                    if (move.type().equals((Object)SchemaChange.Move.MoveType.FIRST)) {
                        SchemaManager.checkMoveIndexEqual(move, fieldIndex, refIndex);
                        newFields.add(refIndex, (DataField)newFields.remove(fieldIndex));
                        continue;
                    }
                    if (!move.type().equals((Object)SchemaChange.Move.MoveType.AFTER)) continue;
                    refIndex = (Integer)map.get(move.referenceFieldName());
                    SchemaManager.checkMoveIndexEqual(move, fieldIndex, refIndex);
                    if (fieldIndex > refIndex) {
                        newFields.add(refIndex + 1, (DataField)newFields.remove(fieldIndex));
                        continue;
                    }
                    newFields.add(refIndex, (DataField)newFields.remove(fieldIndex));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported change: " + change.getClass());
            }
        } while (!(success = this.commit(newSchema = new TableSchema(schema.id() + 1L, newFields, highestFieldId.get(), schema.partitionKeys(), schema.primaryKeys(), newOptions, schema.comment()))));
        return newSchema;
    }

    private static void checkMoveIndexEqual(SchemaChange.Move move, int fieldIndex, int refIndex) {
        if (refIndex == fieldIndex) {
            throw new UnsupportedOperationException(String.format("Cannot move itself for column %s", move.fieldName()));
        }
    }

    private void validateNotPrimaryAndPartitionKey(TableSchema schema, String fieldName) {
        if (schema.partitionKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename partition key[%s]", fieldName));
        }
        if (schema.primaryKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename primary key[%s]", fieldName));
        }
    }

    private void updateNestedColumn(List<DataField> newFields, String[] updateFieldNames, int index, Function<DataField, DataField> updateFunc) {
        boolean found = false;
        for (int i = 0; i < newFields.size(); ++i) {
            DataField field = newFields.get(i);
            if (!field.name().equals(updateFieldNames[index])) continue;
            found = true;
            if (index == updateFieldNames.length - 1) {
                newFields.set(i, updateFunc.apply(field));
                break;
            }
            ArrayList<DataField> nestedFields = new ArrayList<DataField>(((RowType)field.type()).getFields());
            this.updateNestedColumn(nestedFields, updateFieldNames, index + 1, updateFunc);
            newFields.set(i, new DataField(field.id(), field.name(), new RowType(field.type().isNullable(), nestedFields), field.description()));
        }
        if (!found) {
            throw new RuntimeException("Can not find column: " + Arrays.asList(updateFieldNames));
        }
    }

    private void updateColumn(List<DataField> newFields, String updateFieldName, Function<DataField, DataField> updateFunc) {
        this.updateNestedColumn(newFields, new String[]{updateFieldName}, 0, updateFunc);
    }

    @VisibleForTesting
    boolean commit(TableSchema newSchema) throws Exception {
        SchemaValidation.validateTableSchema(newSchema);
        Path schemaPath = this.toSchemaPath(newSchema.id());
        Callable<Boolean> callable = () -> this.fileIO.writeFileUtf8(schemaPath, newSchema.toString());
        if (this.lock == null) {
            return callable.call();
        }
        return this.lock.runWithLock(callable);
    }

    public TableSchema schema(long id) {
        try {
            return JsonSerdeUtil.fromJson(this.fileIO.readFileUtf8(this.toSchemaPath(id)), TableSchema.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path schemaDirectory() {
        return new Path(this.tableRoot + "/schema");
    }

    @VisibleForTesting
    public Path toSchemaPath(long id) {
        return new Path(this.tableRoot + "/schema/" + SCHEMA_PREFIX + id);
    }

    public void deleteSchema(long schemaId) {
        this.fileIO.deleteQuietly(this.toSchemaPath(schemaId));
    }

    public static void checkAlterTableOption(String key) {
        if (CoreOptions.getImmutableOptionKeys().contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
    }

    private static /* synthetic */ DataField lambda$commitChanges$8(SchemaChange.UpdateColumnComment update, DataField field) {
        return new DataField(field.id(), field.name(), field.type(), update.newDescription());
    }

    private static /* synthetic */ DataField lambda$commitChanges$7(SchemaChange.UpdateColumnNullability update, DataField field) {
        return new DataField(field.id(), field.name(), field.type().copy(update.newNullability()), field.description());
    }

    private static /* synthetic */ DataField lambda$commitChanges$6(SchemaChange.UpdateColumnType update, DataField field) {
        Preconditions.checkState(DataTypeCasts.supportsImplicitCast(field.type(), update.newDataType()) && CastExecutors.resolve(field.type(), update.newDataType()) != null, String.format("Column type %s[%s] cannot be converted to %s without loosing information.", field.name(), field.type(), update.newDataType()));
        AtomicInteger dummyId = new AtomicInteger(0);
        if (dummyId.get() != 0) {
            throw new RuntimeException(String.format("Update column to nested row type '%s' is not supported.", update.newDataType()));
        }
        return new DataField(field.id(), field.name(), update.newDataType());
    }
}

