/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.WriteMode;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SystemColumns;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class SchemaValidation {
    public static final List<Class<? extends DataType>> PRIMARY_KEY_UNSUPPORTED_LOGICAL_TYPES = Arrays.asList(MapType.class, ArrayType.class, RowType.class, MultisetType.class);

    public static void validateTableSchema(TableSchema schema) {
        SchemaValidation.validatePrimaryKeysType(schema.fields(), schema.primaryKeys());
        CoreOptions options = new CoreOptions(schema.options());
        if (options.startupMode() == CoreOptions.StartupMode.FROM_TIMESTAMP) {
            SchemaValidation.checkOptionExistInMode(options, CoreOptions.SCAN_TIMESTAMP_MILLIS, CoreOptions.StartupMode.FROM_TIMESTAMP);
            SchemaValidation.checkOptionsConflict(options, CoreOptions.SCAN_SNAPSHOT_ID, CoreOptions.SCAN_TIMESTAMP_MILLIS);
        } else if (options.startupMode() == CoreOptions.StartupMode.FROM_SNAPSHOT || options.startupMode() == CoreOptions.StartupMode.FROM_SNAPSHOT_FULL) {
            SchemaValidation.checkOptionExistInMode(options, CoreOptions.SCAN_SNAPSHOT_ID, options.startupMode());
            SchemaValidation.checkOptionsConflict(options, CoreOptions.SCAN_TIMESTAMP_MILLIS, CoreOptions.SCAN_SNAPSHOT_ID);
        } else {
            SchemaValidation.checkOptionNotExistInMode(options, CoreOptions.SCAN_TIMESTAMP_MILLIS, options.startupMode());
            SchemaValidation.checkOptionNotExistInMode(options, CoreOptions.SCAN_SNAPSHOT_ID, options.startupMode());
        }
        Preconditions.checkArgument(options.snapshotNumRetainMin() > 0, CoreOptions.SNAPSHOT_NUM_RETAINED_MIN.key() + " should be at least 1");
        Preconditions.checkArgument(options.snapshotNumRetainMin() <= options.snapshotNumRetainMax(), CoreOptions.SNAPSHOT_NUM_RETAINED_MIN.key() + " should not be larger than " + CoreOptions.SNAPSHOT_NUM_RETAINED_MAX.key());
        if (options.writeMode() == WriteMode.CHANGE_LOG) {
            switch (options.changelogProducer()) {
                case FULL_COMPACTION: 
                case LOOKUP: {
                    if (!schema.primaryKeys().isEmpty()) break;
                    throw new UnsupportedOperationException("Changelog table with " + options.changelogProducer() + " must have primary keys");
                }
            }
        }
        CoreOptions.FileFormatType fileFormatType = options.formatType();
        FileFormat fileFormat = FileFormat.fromIdentifier(fileFormatType.name(), new Options(schema.options()));
        fileFormat.validateDataFields(new RowType(schema.fields()));
        schema.fieldNames().forEach(f -> {
            Preconditions.checkState(!SystemColumns.SYSTEM_FIELD_NAMES.contains(f), String.format("Field name[%s] in schema cannot be exist in %s", f, SystemColumns.SYSTEM_FIELD_NAMES));
            Preconditions.checkState(!f.startsWith("_KEY_"), String.format("Field name[%s] in schema cannot start with [%s]", f, "_KEY_"));
        });
        if (!schema.primaryKeys().isEmpty() && Objects.equals(WriteMode.APPEND_ONLY, options.writeMode())) {
            throw new RuntimeException("Cannot define any primary key in an append-only table. Set 'write-mode'='change-log' if still want to keep the primary key definition.");
        }
        if (schema.primaryKeys().isEmpty() && options.streamingReadOverwrite()) {
            throw new RuntimeException("Doesn't support streaming read the changes from overwrite when the primary keys are not defined.");
        }
        if (schema.options().containsKey(CoreOptions.PARTITION_EXPIRATION_TIME.key()) && schema.partitionKeys().isEmpty()) {
            throw new IllegalArgumentException("Can not set 'partition.expiration-time' for non-partitioned table.");
        }
        Optional<String> sequenceField = options.sequenceField();
        sequenceField.ifPresent(field -> Preconditions.checkArgument(schema.fieldNames().contains(field), "Nonexistent sequence field: '%s'", field));
    }

    private static void validatePrimaryKeysType(List<DataField> fields, List<String> primaryKeys) {
        if (!primaryKeys.isEmpty()) {
            HashMap<String, DataField> rowFields = new HashMap<String, DataField>();
            for (DataField rowField : fields) {
                rowFields.put(rowField.name(), rowField);
            }
            for (String primaryKeyName : primaryKeys) {
                DataField rowField = (DataField)rowFields.get(primaryKeyName);
                DataType dataType = rowField.type();
                if (!PRIMARY_KEY_UNSUPPORTED_LOGICAL_TYPES.stream().anyMatch(c -> c.isInstance(dataType))) continue;
                throw new UnsupportedOperationException(String.format("The type %s in primary key field %s is unsupported", dataType.getClass().getSimpleName(), primaryKeyName));
            }
        }
    }

    private static void checkOptionExistInMode(CoreOptions options, ConfigOption<?> option, CoreOptions.StartupMode startupMode) {
        Preconditions.checkArgument(options.toConfiguration().contains(option), String.format("%s can not be null when you use %s for %s", option.key(), startupMode, CoreOptions.SCAN_MODE.key()));
    }

    private static void checkOptionNotExistInMode(CoreOptions options, ConfigOption<?> option, CoreOptions.StartupMode startupMode) {
        Preconditions.checkArgument(!options.toConfiguration().contains(option), String.format("%s must be null when you use %s for %s", option.key(), startupMode, CoreOptions.SCAN_MODE.key()));
    }

    private static void checkOptionsConflict(CoreOptions options, ConfigOption<?> illegalOption, ConfigOption<?> legalOption) {
        Preconditions.checkArgument(!options.toConfiguration().contains(illegalOption), String.format("%s must be null when you set %s", illegalOption.key(), legalOption.key()));
    }
}

