/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.shade.org.apache.orc.FileFormatException;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.ReaderImpl;
import org.apache.paimon.shade.org.apache.orc.impl.SchemaEvolution;

public class OrcUtils {
    public static boolean[] includeColumns(String selectedColumns, TypeDescription schema) {
        TypeDescription baseSchema;
        int numFlattenedCols = schema.getMaximumId();
        boolean[] results = new boolean[numFlattenedCols + 1];
        if ("*".equals(selectedColumns)) {
            Arrays.fill(results, true);
            return results;
        }
        TypeDescription typeDescription = baseSchema = SchemaEvolution.checkAcidSchema(schema) ? SchemaEvolution.getBaseRow(schema) : schema;
        if (selectedColumns != null && baseSchema.getCategory() == TypeDescription.Category.STRUCT) {
            for (String columnName : selectedColumns.split(",")) {
                TypeDescription column = OrcUtils.findColumn(baseSchema, columnName.trim());
                if (column == null) continue;
                for (int i = column.getId(); i <= column.getMaximumId(); ++i) {
                    results[i] = true;
                }
            }
        }
        return results;
    }

    private static TypeDescription findColumn(TypeDescription schema, String column) {
        TypeDescription result = schema;
        String[] columnMatcher = column.split("\\.");
        int index = 0;
        while (index < columnMatcher.length && result.getCategory() == TypeDescription.Category.STRUCT) {
            String columnName = columnMatcher[index];
            int prevIndex = index;
            List<TypeDescription> fields = result.getChildren();
            List<String> fieldNames = result.getFieldNames();
            for (int i = 0; i < fields.size(); ++i) {
                if (!columnName.equalsIgnoreCase(fieldNames.get(i))) continue;
                result = fields.get(i);
                ++index;
                break;
            }
            if (prevIndex != index) continue;
            return null;
        }
        return result;
    }

    public static List<OrcProto.Type> getOrcTypes(TypeDescription typeDescr) {
        ArrayList<OrcProto.Type> result = new ArrayList<OrcProto.Type>();
        OrcUtils.appendOrcTypes(result, typeDescr);
        return result;
    }

    private static void appendOrcTypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(children.get(0).getId());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                for (String field : typeDescr.getFieldNames()) {
                    type.addFieldNames(field);
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        result.add(type.build());
        if (children != null) {
            for (TypeDescription child : children) {
                OrcUtils.appendOrcTypes(result, child);
            }
        }
    }

    public static void appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        int subtype = result.size();
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(++subtype);
                result.add(type.build());
                needsAdd = false;
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                break;
            }
            case MAP: {
                result.add(null);
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                int subtype2 = result.size();
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(1));
                type.setKind(OrcProto.Type.Kind.MAP);
                type.addSubtypes(subtype + 1);
                type.addSubtypes(subtype2);
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                List<String> fieldNames = typeDescr.getFieldNames();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (TypeDescription child : children) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (int i = 0; i < fieldNames.size(); ++i) {
                    type.addSubtypes((Integer)fieldSubtypes.get(i));
                    type.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(children.size());
                for (TypeDescription child : children) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.UNION);
                for (int i = 0; i < children.size(); ++i) {
                    type.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        if (needsAdd) {
            result.add(type.build());
        }
    }

    public static int appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, List<OrcProto.Type> types, int columnId) {
        OrcProto.Type oldType = types.get(columnId++);
        int subtype = result.size();
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        switch (oldType.getKind()) {
            case BOOLEAN: {
                builder.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                builder.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                builder.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                builder.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                builder.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                builder.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                builder.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                builder.setKind(OrcProto.Type.Kind.CHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case VARCHAR: {
                builder.setKind(OrcProto.Type.Kind.VARCHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case BINARY: {
                builder.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                builder.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                builder.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                builder.setKind(OrcProto.Type.Kind.DECIMAL);
                builder.setPrecision(oldType.getPrecision());
                builder.setScale(oldType.getScale());
                break;
            }
            case LIST: {
                builder.setKind(OrcProto.Type.Kind.LIST);
                builder.addSubtypes(++subtype);
                result.add(builder.build());
                needsAdd = false;
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                break;
            }
            case MAP: {
                result.add(null);
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                int subtype2 = result.size();
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                builder.setKind(OrcProto.Type.Kind.MAP);
                builder.addSubtypes(subtype + 1);
                builder.addSubtypes(subtype2);
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                int i;
                List<String> fieldNames = oldType.getFieldNamesList();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (i = 0; i < fieldNames.size(); ++i) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.STRUCT);
                for (i = 0; i < fieldNames.size(); ++i) {
                    builder.addSubtypes((Integer)fieldSubtypes.get(i));
                    builder.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                int i;
                int subtypeCount = oldType.getSubtypesCount();
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(subtypeCount);
                for (i = 0; i < subtypeCount; ++i) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.UNION);
                for (i = 0; i < subtypeCount; ++i) {
                    builder.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + oldType.getKind());
            }
        }
        if (needsAdd) {
            result.add(builder.build());
        }
        return columnId;
    }

    public static int isValidTypeTree(List<OrcProto.Type> types, int root) throws IOException {
        if (root < 0 || root >= types.size()) {
            throw new IOException("Illegal type id " + root + ". The valid range is 0 to " + (types.size() - 1));
        }
        OrcProto.Type rootType = types.get(root);
        int current = root + 1;
        List<Integer> children = rootType.getSubtypesList();
        if (!rootType.hasKind()) {
            throw new IOException("Type " + root + " has an unknown kind.");
        }
        switch (rootType.getKind()) {
            case LIST: {
                if (children != null && children.size() == 1) break;
                throw new IOException("Wrong number of type children in list " + root);
            }
            case MAP: {
                if (children != null && children.size() == 2) break;
                throw new IOException("Wrong number of type children in map " + root);
            }
            case STRUCT: 
            case UNION: {
                break;
            }
            default: {
                if (children == null || children.size() == 0) break;
                throw new IOException("Type children under primitive type " + root);
            }
        }
        if (children != null) {
            for (int child : children) {
                if (child != current) {
                    throw new IOException("Unexpected child type id " + child + " when " + current + " was expected.");
                }
                current = OrcUtils.isValidTypeTree(types, current);
            }
        }
        return current;
    }

    public static TypeDescription convertTypeFromProtobuf(List<OrcProto.Type> types, int rootColumn) throws FileFormatException {
        OrcProto.Type type = types.get(rootColumn);
        switch (type.getKind()) {
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case BYTE: {
                return TypeDescription.createByte();
            }
            case SHORT: {
                return TypeDescription.createShort();
            }
            case INT: {
                return TypeDescription.createInt();
            }
            case LONG: {
                return TypeDescription.createLong();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case CHAR: 
            case VARCHAR: {
                TypeDescription result;
                TypeDescription typeDescription = result = type.getKind() == OrcProto.Type.Kind.CHAR ? TypeDescription.createChar() : TypeDescription.createVarchar();
                if (type.hasMaximumLength()) {
                    result.withMaxLength(type.getMaximumLength());
                }
                return result;
            }
            case BINARY: {
                return TypeDescription.createBinary();
            }
            case TIMESTAMP: {
                return TypeDescription.createTimestamp();
            }
            case DATE: {
                return TypeDescription.createDate();
            }
            case DECIMAL: {
                TypeDescription result = TypeDescription.createDecimal();
                if (type.hasScale()) {
                    result.withScale(type.getScale());
                }
                if (type.hasPrecision()) {
                    result.withPrecision(type.getPrecision());
                }
                return result;
            }
            case LIST: {
                if (type.getSubtypesCount() != 1) {
                    throw new FileFormatException("LIST type should contain exactly one subtype but has " + type.getSubtypesCount());
                }
                return TypeDescription.createList(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)));
            }
            case MAP: {
                if (type.getSubtypesCount() != 2) {
                    throw new FileFormatException("MAP type should contain exactly two subtypes but has " + type.getSubtypesCount());
                }
                return TypeDescription.createMap(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)), OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(1)));
            }
            case STRUCT: {
                TypeDescription result = TypeDescription.createStruct();
                for (int f = 0; f < type.getSubtypesCount(); ++f) {
                    result.addField(type.getFieldNames(f), OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                return result;
            }
            case UNION: {
                if (type.getSubtypesCount() == 0) {
                    throw new FileFormatException("UNION type should contain at least one subtype but has none");
                }
                TypeDescription result = TypeDescription.createUnion();
                for (int f = 0; f < type.getSubtypesCount(); ++f) {
                    result.addUnionChild(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown ORC type " + type.getKind());
    }

    public static List<StripeInformation> convertProtoStripesToStripes(List<OrcProto.StripeInformation> stripes) {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(stripes.size());
        for (OrcProto.StripeInformation info : stripes) {
            result.add(new ReaderImpl.StripeInformationImpl(info));
        }
        return result;
    }
}

