/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.source.InnerStreamTableScan;
import org.apache.paimon.table.source.InnerStreamTableScanImpl;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.InnerTableScanImpl;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReaderImpl;
import org.apache.paimon.table.source.snapshot.StaticFromTimestampStartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public abstract class AbstractFileStoreTable
implements FileStoreTable {
    private static final long serialVersionUID = 1L;
    protected final FileIO fileIO;
    protected final Path path;
    protected final TableSchema tableSchema;

    public AbstractFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this.fileIO = fileIO;
        this.path = path;
        if (!tableSchema.options().containsKey(CoreOptions.PATH.key())) {
            HashMap<String, String> newOptions = new HashMap<String, String>(tableSchema.options());
            newOptions.put(CoreOptions.PATH.key(), path.toString());
            tableSchema = tableSchema.copy(newOptions);
        }
        this.tableSchema = tableSchema;
    }

    @VisibleForTesting
    public abstract FileStore<?> store();

    @Override
    public SnapshotSplitReader newSnapshotSplitReader() {
        return new SnapshotSplitReaderImpl(this.store().newScan(), this.tableSchema, this.coreOptions(), this.snapshotManager(), this.splitGenerator(), this.nonPartitionFilterConsumer());
    }

    @Override
    public InnerTableScan newScan() {
        return new InnerTableScanImpl(this.coreOptions(), this.newSnapshotSplitReader(), this.snapshotManager());
    }

    @Override
    public InnerStreamTableScan newStreamScan() {
        return new InnerStreamTableScanImpl(this.coreOptions(), this.newSnapshotSplitReader(), this.snapshotManager(), this.supportStreamingReadOverwrite());
    }

    public abstract SplitGenerator splitGenerator();

    protected abstract boolean supportStreamingReadOverwrite();

    public abstract BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer();

    protected abstract FileStoreTable copy(TableSchema var1);

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        Map<String, String> options = this.tableSchema.options();
        dynamicOptions.forEach((k, v) -> {
            if (!Objects.equals(v, options.get(k))) {
                SchemaManager.checkAlterTableOption(k);
            }
        });
        return this.internalCopyWithoutCheck(dynamicOptions);
    }

    @Override
    public FileStoreTable internalCopyWithoutCheck(Map<String, String> dynamicOptions) {
        HashMap<String, String> options = new HashMap<String, String>(this.tableSchema.options());
        dynamicOptions.forEach((k, v) -> {
            if (v == null) {
                options.remove(k);
            } else {
                options.put((String)k, (String)v);
            }
        });
        Options newOptions = Options.fromMap(options);
        newOptions.set(CoreOptions.PATH, this.path.toString());
        CoreOptions.setDefaultValues(newOptions);
        TableSchema newTableSchema = this.tableSchema.copy(newOptions.toMap());
        SchemaValidation.validateTableSchema(newTableSchema);
        newTableSchema = this.tryTimeTravel(newOptions).orElse(newTableSchema);
        return this.copy(newTableSchema);
    }

    @Override
    public FileStoreTable copyWithLatestSchema() {
        Map<String, String> options = this.tableSchema.options();
        SchemaManager schemaManager = new SchemaManager(this.fileIO(), this.location());
        Optional<TableSchema> optionalLatestSchema = schemaManager.latest();
        if (optionalLatestSchema.isPresent()) {
            TableSchema newTableSchema = optionalLatestSchema.get();
            newTableSchema = newTableSchema.copy(options);
            SchemaValidation.validateTableSchema(newTableSchema);
            return this.copy(newTableSchema);
        }
        return this;
    }

    protected SchemaManager schemaManager() {
        return new SchemaManager(this.fileIO(), this.path);
    }

    @Override
    public CoreOptions coreOptions() {
        return this.store().options();
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    @Override
    public Path location() {
        return this.path;
    }

    @Override
    public TableSchema schema() {
        return this.tableSchema;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.store().snapshotManager();
    }

    @Override
    public TableCommitImpl newCommit(String commitUser) {
        return new TableCommitImpl(this.store().newCommit(commitUser), this.coreOptions().writeOnly() ? null : this.store().newExpire(), this.coreOptions().writeOnly() ? null : this.store().newPartitionExpire(commitUser));
    }

    private Optional<TableSchema> tryTimeTravel(Options options) {
        CoreOptions coreOptions = new CoreOptions(options);
        switch (coreOptions.startupMode()) {
            case FROM_SNAPSHOT: 
            case FROM_SNAPSHOT_FULL: {
                Long snapshotId = coreOptions.scanSnapshotId();
                if (this.snapshotManager().snapshotExists(snapshotId)) {
                    long schemaId = this.snapshotManager().snapshot(snapshotId).schemaId();
                    return Optional.of(this.schemaManager().schema(schemaId).copy(options.toMap()));
                }
                return Optional.empty();
            }
            case FROM_TIMESTAMP: {
                Snapshot snapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(this.snapshotManager(), coreOptions.scanTimestampMills());
                if (snapshot != null) {
                    long schemaId = snapshot.schemaId();
                    return Optional.of(this.schemaManager().schema(schemaId).copy(options.toMap()));
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

