/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.WriteMode;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.ChangelogValueCountFileStoreTable;
import org.apache.paimon.table.ChangelogWithKeyFileStoreTable;
import org.apache.paimon.table.FileStoreTable;

public class FileStoreTableFactory {
    public static FileStoreTable create(CatalogContext context) {
        FileIO fileIO;
        try {
            fileIO = FileIO.get(CoreOptions.path(context.options()), context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return FileStoreTableFactory.create(fileIO, context.options());
    }

    public static FileStoreTable create(FileIO fileIO, Path path) {
        Options options = new Options();
        options.set(CoreOptions.PATH, path.toString());
        return FileStoreTableFactory.create(fileIO, options);
    }

    public static FileStoreTable create(FileIO fileIO, Options options) {
        Path tablePath = CoreOptions.path(options);
        TableSchema tableSchema = new SchemaManager(fileIO, tablePath).latest().orElseThrow(() -> new IllegalArgumentException("Schema file not found in location " + tablePath + ". Please create table first."));
        return FileStoreTableFactory.create(fileIO, tablePath, tableSchema, options);
    }

    public static FileStoreTable create(FileIO fileIO, Path tablePath, TableSchema tableSchema) {
        return FileStoreTableFactory.create(fileIO, tablePath, tableSchema, new Options());
    }

    public static FileStoreTable create(FileIO fileIO, Path tablePath, TableSchema tableSchema, Options dynamicOptions) {
        Options coreOptions = Options.fromMap(tableSchema.options());
        WriteMode writeMode = coreOptions.get(CoreOptions.WRITE_MODE);
        if (writeMode == WriteMode.AUTO) {
            writeMode = tableSchema.primaryKeys().isEmpty() ? WriteMode.APPEND_ONLY : WriteMode.CHANGE_LOG;
            coreOptions.set(CoreOptions.WRITE_MODE, writeMode);
        }
        AbstractFileStoreTable table = writeMode == WriteMode.APPEND_ONLY ? new AppendOnlyFileStoreTable(fileIO, tablePath, tableSchema) : (tableSchema.primaryKeys().isEmpty() ? new ChangelogValueCountFileStoreTable(fileIO, tablePath, tableSchema) : new ChangelogWithKeyFileStoreTable(fileIO, tablePath, tableSchema));
        return table.copy((Map)dynamicOptions.toMap());
    }
}

