/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateFilter;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.InnerTableCommit;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.CloseableIterator;

public class TableUtils {
    public static void deleteWhere(Table table, List<Predicate> filters, Lock.Factory lockFactory) {
        ReadBuilder readBuilder = table.newReadBuilder().withFilter(filters);
        BatchWriteBuilder writeBuilder = table.newBatchWriteBuilder();
        List<Split> splits = readBuilder.newScan().plan().splits();
        try (RecordReader<InternalRow> reader = readBuilder.newRead().createReader(splits);
             BatchTableWrite write = writeBuilder.newWrite();
             InnerTableCommit commit = ((InnerTableCommit)writeBuilder.newCommit()).withLock(lockFactory.create());){
            CloseableIterator<InternalRow> iterator = reader.toCloseableIterator();
            PredicateFilter filter = new PredicateFilter(table.rowType(), filters);
            while (iterator.hasNext()) {
                InternalRow row = (InternalRow)iterator.next();
                if (!filter.test(row)) continue;
                row.setRowKind(RowKind.DELETE);
                write.write(row);
            }
            commit.commit(write.prepareCommit());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

