/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageImpl
implements CommitMessage {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CommitMessageSerializer> CACHE = ThreadLocal.withInitial(CommitMessageSerializer::new);
    private transient BinaryRow partition;
    private transient int bucket;
    private transient NewFilesIncrement newFilesIncrement;
    private transient CompactIncrement compactIncrement;

    public CommitMessageImpl(BinaryRow partition, int bucket, NewFilesIncrement newFilesIncrement, CompactIncrement compactIncrement) {
        this.partition = partition;
        this.bucket = bucket;
        this.newFilesIncrement = newFilesIncrement;
        this.compactIncrement = compactIncrement;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    public NewFilesIncrement newFilesIncrement() {
        return this.newFilesIncrement;
    }

    public CompactIncrement compactIncrement() {
        return this.compactIncrement;
    }

    public boolean isEmpty() {
        return this.newFilesIncrement.isEmpty() && this.compactIncrement.isEmpty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CommitMessageSerializer serializer = CACHE.get();
        out.writeInt(serializer.getVersion());
        SerializationUtils.serializeBytes(new DataOutputViewStreamWrapper(out), serializer.serialize(this));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        byte[] bytes = SerializationUtils.deserializedBytes(new DataInputViewStreamWrapper(in));
        CommitMessageImpl message = (CommitMessageImpl)CACHE.get().deserialize(version, bytes);
        this.partition = message.partition;
        this.bucket = message.bucket;
        this.newFilesIncrement = message.newFilesIncrement;
        this.compactIncrement = message.compactIncrement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitMessageImpl that = (CommitMessageImpl)o;
        return this.bucket == that.bucket && Objects.equals(this.partition, that.partition) && Objects.equals(this.newFilesIncrement, that.newFilesIncrement) && Objects.equals(this.compactIncrement, that.compactIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.newFilesIncrement, this.compactIncrement);
    }

    public String toString() {
        return String.format("FileCommittable {partition = %s, bucket = %d, newFilesIncrement = %s, compactIncrement = %s}", this.partition, this.bucket, this.newFilesIncrement, this.compactIncrement);
    }
}

