/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;

public class InternalRowKeyAndBucketExtractor
implements KeyAndBucketExtractor<InternalRow> {
    private final int numBuckets;
    private final boolean sameBucketKeyAndTrimmedPrimaryKey;
    private final Projection partitionProjection;
    private final Projection bucketKeyProjection;
    private final Projection trimmedPrimaryKeyProjection;
    private final Projection logPrimaryKeyProjection;
    private InternalRow record;
    private BinaryRow partition;
    private BinaryRow bucketKey;
    private Integer bucket;
    private BinaryRow trimmedPrimaryKey;
    private BinaryRow logPrimaryKey;

    public InternalRowKeyAndBucketExtractor(TableSchema schema) {
        this.numBuckets = new CoreOptions(schema.options()).bucket();
        this.sameBucketKeyAndTrimmedPrimaryKey = schema.bucketKeys().equals(schema.trimmedPrimaryKeys());
        this.partitionProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.partitionKeys()));
        this.bucketKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.bucketKeys()));
        this.trimmedPrimaryKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.trimmedPrimaryKeys()));
        this.logPrimaryKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.primaryKeys()));
    }

    @Override
    public void setRecord(InternalRow record) {
        this.record = record;
        this.partition = null;
        this.bucketKey = null;
        this.bucket = null;
        this.trimmedPrimaryKey = null;
        this.logPrimaryKey = null;
    }

    @Override
    public BinaryRow partition() {
        if (this.partition == null) {
            this.partition = this.partitionProjection.apply(this.record);
        }
        return this.partition;
    }

    @Override
    public int bucket() {
        if (this.bucketKey == null) {
            this.bucketKey = this.bucketKeyProjection.apply(this.record);
            if (this.sameBucketKeyAndTrimmedPrimaryKey) {
                this.trimmedPrimaryKey = this.bucketKey;
            }
        }
        if (this.bucket == null) {
            this.bucket = KeyAndBucketExtractor.bucket(KeyAndBucketExtractor.bucketKeyHashCode(this.bucketKey), this.numBuckets);
        }
        return this.bucket;
    }

    @Override
    public BinaryRow trimmedPrimaryKey() {
        if (this.trimmedPrimaryKey == null) {
            this.trimmedPrimaryKey = this.trimmedPrimaryKeyProjection.apply(this.record);
            if (this.sameBucketKeyAndTrimmedPrimaryKey) {
                this.bucketKey = this.trimmedPrimaryKey;
            }
        }
        return this.trimmedPrimaryKey;
    }

    @Override
    public BinaryRow logPrimaryKey() {
        if (this.logPrimaryKey == null) {
            assert (this.logPrimaryKeyProjection != null);
            this.logPrimaryKey = this.logPrimaryKeyProjection.apply(this.record);
        }
        return this.logPrimaryKey;
    }
}

