/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.InternalRowUtils;

public class SequenceGenerator {
    private final int index;
    private final Generator generator;

    public SequenceGenerator(String field, RowType rowType) {
        this.index = rowType.getFieldNames().indexOf(field);
        if (this.index == -1) {
            throw new RuntimeException(String.format("Can not find sequence field %s in table schema: %s", field, rowType));
        }
        this.generator = rowType.getTypeAt(this.index).accept(new SequenceGeneratorVisitor());
    }

    public long generate(InternalRow row) {
        return this.generator.generate(row, this.index);
    }

    private static class SequenceGeneratorVisitor
    extends DataTypeDefaultVisitor<Generator> {
        private SequenceGeneratorVisitor() {
        }

        @Override
        public Generator visit(CharType charType) {
            return this.stringGenerator();
        }

        @Override
        public Generator visit(VarCharType varCharType) {
            return this.stringGenerator();
        }

        private Generator stringGenerator() {
            return (row, i) -> Long.parseLong(row.getString(i).toString());
        }

        @Override
        public Generator visit(DecimalType decimalType) {
            return (row, i) -> InternalRowUtils.castToIntegral(row.getDecimal(i, decimalType.getPrecision(), decimalType.getScale()));
        }

        @Override
        public Generator visit(TinyIntType tinyIntType) {
            return DataGetters::getByte;
        }

        @Override
        public Generator visit(SmallIntType smallIntType) {
            return DataGetters::getShort;
        }

        @Override
        public Generator visit(IntType intType) {
            return DataGetters::getInt;
        }

        @Override
        public Generator visit(BigIntType bigIntType) {
            return DataGetters::getLong;
        }

        @Override
        public Generator visit(FloatType floatType) {
            return (row, i) -> (long)row.getFloat(i);
        }

        @Override
        public Generator visit(DoubleType doubleType) {
            return (row, i) -> (long)row.getDouble(i);
        }

        @Override
        public Generator visit(DateType dateType) {
            return DataGetters::getInt;
        }

        @Override
        public Generator visit(TimestampType timestampType) {
            return (row, i) -> row.getTimestamp(i, timestampType.getPrecision()).getMillisecond();
        }

        @Override
        public Generator visit(LocalZonedTimestampType localZonedTimestampType) {
            return (row, i) -> row.getTimestamp(i, localZonedTimestampType.getPrecision()).getMillisecond();
        }

        @Override
        protected Generator defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }

    private static interface Generator {
        public long generate(InternalRow var1, int var2);
    }
}

