/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreExpire;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.InnerTableCommit;
import org.apache.paimon.utils.Preconditions;

public class TableCommitImpl
implements InnerTableCommit {
    private final FileStoreCommit commit;
    @Nullable
    private final FileStoreExpire expire;
    @Nullable
    private final PartitionExpire partitionExpire;
    @Nullable
    private Map<String, String> overwritePartition = null;
    @Nullable
    private Lock lock;
    private boolean batchCommitted = false;

    public TableCommitImpl(FileStoreCommit commit, @Nullable FileStoreExpire expire, @Nullable PartitionExpire partitionExpire) {
        this.commit = commit;
        this.expire = expire;
        this.partitionExpire = partitionExpire;
    }

    @Override
    public TableCommitImpl withOverwrite(@Nullable Map<String, String> overwritePartitions) {
        this.overwritePartition = overwritePartitions;
        return this;
    }

    @Override
    public TableCommitImpl withLock(Lock lock) {
        this.commit.withLock(lock);
        if (this.expire != null) {
            this.expire.withLock(lock);
        }
        if (this.partitionExpire != null) {
            this.partitionExpire.withLock(lock);
        }
        this.lock = lock;
        return this;
    }

    @Override
    public TableCommitImpl ignoreEmptyCommit(boolean ignoreEmptyCommit) {
        this.commit.ignoreEmptyCommit(ignoreEmptyCommit);
        return this;
    }

    @Override
    public Set<Long> filterCommitted(Set<Long> commitIdentifiers) {
        return this.commit.filterCommitted(commitIdentifiers);
    }

    @Override
    public void commit(long identifier, List<CommitMessage> commitMessages) {
        ManifestCommittable committable = new ManifestCommittable(identifier);
        for (CommitMessage commitMessage : commitMessages) {
            committable.addFileCommittable(commitMessage);
        }
        if (this.overwritePartition == null) {
            this.commit.commit(committable, new HashMap<String, String>());
        } else {
            this.commit.overwrite(this.overwritePartition, committable, Collections.emptyMap());
        }
        this.expire(identifier);
    }

    public void commit(ManifestCommittable committable) {
        this.commitMultiple(Collections.singletonList(committable));
    }

    public void commitMultiple(List<ManifestCommittable> committables) {
        if (this.overwritePartition == null) {
            for (ManifestCommittable committable : committables) {
                this.commit.commit(committable, new HashMap<String, String>());
            }
            if (!committables.isEmpty()) {
                this.expire(committables.get(committables.size() - 1).identifier());
            }
        } else {
            if (committables.size() > 1) {
                throw new RuntimeException("Multiple committables appear in overwrite mode, this may be a bug, please report it: " + committables);
            }
            ManifestCommittable committable = committables.size() == 1 ? committables.get(0) : new ManifestCommittable(Long.MAX_VALUE);
            this.commit.overwrite(this.overwritePartition, committable, Collections.emptyMap());
            this.expire(committable.identifier());
        }
    }

    private void expire(long partitionExpireIdentifier) {
        if (this.expire != null) {
            this.expire.expire();
        }
        if (this.partitionExpire != null) {
            this.partitionExpire.expire(partitionExpireIdentifier);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.lock != null) {
            this.lock.close();
        }
    }

    @Override
    public void commit(List<CommitMessage> commitMessages) {
        Preconditions.checkState(!this.batchCommitted, "BatchTableCommit only support one-time committing.");
        this.batchCommitted = true;
        this.commit(Long.MAX_VALUE, commitMessages);
    }

    @Override
    public void abort(List<CommitMessage> commitMessages) {
        this.commit.abort(commitMessages);
    }
}

