/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.List;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.InnerTableWrite;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Restorable;

public class TableWriteImpl<T>
implements InnerTableWrite,
Restorable<List<AbstractFileStoreWrite.State>> {
    private final AbstractFileStoreWrite<T> write;
    private final KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor;
    private final RecordExtractor<T> recordExtractor;
    private boolean batchCommitted = false;

    public TableWriteImpl(FileStoreWrite<T> write, KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor, RecordExtractor<T> recordExtractor) {
        this.write = (AbstractFileStoreWrite)write;
        this.keyAndBucketExtractor = keyAndBucketExtractor;
        this.recordExtractor = recordExtractor;
    }

    @Override
    public TableWriteImpl<T> withOverwrite(boolean overwrite) {
        this.write.withOverwrite(overwrite);
        return this;
    }

    @Override
    public TableWriteImpl<T> withIOManager(IOManager ioManager) {
        this.write.withIOManager(ioManager);
        return this;
    }

    @Override
    public BinaryRow getPartition(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.partition();
    }

    @Override
    public int getBucket(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.bucket();
    }

    @Override
    public void write(InternalRow row) throws Exception {
        this.writeAndReturn(row);
    }

    public SinkRecord writeAndReturn(InternalRow row) throws Exception {
        this.keyAndBucketExtractor.setRecord(row);
        SinkRecord record = new SinkRecord(this.keyAndBucketExtractor.partition(), this.keyAndBucketExtractor.bucket(), this.keyAndBucketExtractor.trimmedPrimaryKey(), row);
        this.write.write(record.partition(), record.bucket(), this.recordExtractor.extract(record));
        return record;
    }

    public SinkRecord toLogRecord(SinkRecord record) {
        this.keyAndBucketExtractor.setRecord(record.row());
        return new SinkRecord(record.partition(), record.bucket(), this.keyAndBucketExtractor.logPrimaryKey(), record.row());
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    public void notifyNewFiles(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<CommitMessage> prepareCommit(boolean waitCompaction, long commitIdentifier) throws Exception {
        return this.write.prepareCommit(waitCompaction, commitIdentifier);
    }

    @Override
    public List<CommitMessage> prepareCommit() throws Exception {
        Preconditions.checkState(!this.batchCommitted, "BatchTableWrite only support one-time committing.");
        this.batchCommitted = true;
        return this.prepareCommit(true, Long.MAX_VALUE);
    }

    @Override
    public void close() throws Exception {
        this.write.close();
    }

    @Override
    public List<AbstractFileStoreWrite.State> checkpoint() {
        return this.write.checkpoint();
    }

    @Override
    public void restore(List<AbstractFileStoreWrite.State> state) {
        this.write.restore(state);
    }

    public static interface RecordExtractor<T> {
        public T extract(SinkRecord var1);
    }
}

