/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.snapshot.CompactedStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousCompactorStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousFromSnapshotStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousFromTimestampStartingScanner;
import org.apache.paimon.table.source.snapshot.ContinuousLatestStartingScanner;
import org.apache.paimon.table.source.snapshot.FullCompactedStartingScanner;
import org.apache.paimon.table.source.snapshot.FullStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromSnapshotStartingScanner;
import org.apache.paimon.table.source.snapshot.StaticFromTimestampStartingScanner;
import org.apache.paimon.utils.Preconditions;

public abstract class AbstractInnerTableScan
implements InnerTableScan {
    private final CoreOptions options;
    protected final SnapshotSplitReader snapshotSplitReader;

    protected AbstractInnerTableScan(CoreOptions options, SnapshotSplitReader snapshotSplitReader) {
        this.options = options;
        this.snapshotSplitReader = snapshotSplitReader;
    }

    @VisibleForTesting
    public AbstractInnerTableScan withBucket(int bucket) {
        this.snapshotSplitReader.withBucket(bucket);
        return this;
    }

    public CoreOptions options() {
        return this.options;
    }

    protected StartingScanner createStartingScanner(boolean isStreaming) {
        ConsumerManager consumerManager;
        Optional<Consumer> consumer;
        if (this.options.toConfiguration().get(CoreOptions.STREAMING_COMPACT).booleanValue()) {
            Preconditions.checkArgument(isStreaming, "Set 'streaming-compact' in batch mode. This is unexpected.");
            return new ContinuousCompactorStartingScanner();
        }
        String consumerId = this.options.consumerId();
        if (consumerId != null && (consumer = (consumerManager = this.snapshotSplitReader.consumerManager()).consumer(consumerId)).isPresent()) {
            return new ContinuousFromSnapshotStartingScanner(consumer.get().nextSnapshot());
        }
        CoreOptions.StartupMode startupMode = this.options.startupMode();
        switch (startupMode) {
            case LATEST_FULL: {
                return new FullStartingScanner();
            }
            case LATEST: {
                return isStreaming ? new ContinuousLatestStartingScanner() : new FullStartingScanner();
            }
            case COMPACTED_FULL: {
                if (this.options.changelogProducer() == CoreOptions.ChangelogProducer.FULL_COMPACTION || this.options.toConfiguration().contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                    int deltaCommits = this.options.toConfiguration().getOptional(CoreOptions.FULL_COMPACTION_DELTA_COMMITS).orElse(1);
                    return new FullCompactedStartingScanner(deltaCommits);
                }
                return new CompactedStartingScanner();
            }
            case FROM_TIMESTAMP: {
                Long startupMillis = this.options.scanTimestampMills();
                Preconditions.checkNotNull(startupMillis, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), CoreOptions.StartupMode.FROM_TIMESTAMP, CoreOptions.SCAN_MODE.key()));
                return isStreaming ? new ContinuousFromTimestampStartingScanner(startupMillis) : new StaticFromTimestampStartingScanner(startupMillis);
            }
            case FROM_SNAPSHOT: 
            case FROM_SNAPSHOT_FULL: {
                Long snapshotId = this.options.scanSnapshotId();
                Preconditions.checkNotNull(snapshotId, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_SNAPSHOT_ID.key(), startupMode, CoreOptions.SCAN_MODE.key()));
                return isStreaming && startupMode == CoreOptions.StartupMode.FROM_SNAPSHOT ? new ContinuousFromSnapshotStartingScanner(snapshotId) : new StaticFromSnapshotStartingScanner(snapshotId);
            }
        }
        throw new UnsupportedOperationException("Unknown startup mode " + startupMode.name());
    }
}

