/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.paimon.append.AppendOnlyCompactManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.utils.OrderedPacking;

public class AppendOnlySplitGenerator
implements SplitGenerator {
    private final long targetSplitSize;
    private final long openFileCost;

    public AppendOnlySplitGenerator(long targetSplitSize, long openFileCost) {
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
    }

    @Override
    public List<List<DataFileMeta>> split(List<DataFileMeta> input) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(input);
        files.sort(AppendOnlyCompactManager.fileComparator(false));
        Function<DataFileMeta, Long> weightFunc = file -> Math.max(file.fileSize(), this.openFileCost);
        return OrderedPacking.pack(files, weightFunc, this.targetSplitSize);
    }
}

