/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.utils.SerializationUtils;

public class DataSplit
implements Split {
    private static final long serialVersionUID = 2L;
    private long snapshotId;
    private BinaryRow partition;
    private int bucket;
    private List<DataFileMeta> files;
    private boolean isIncremental;
    private boolean reverseRowKind;

    public DataSplit(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files, boolean isIncremental) {
        this.init(snapshotId, partition, bucket, files, isIncremental, false);
    }

    public DataSplit(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files, boolean isIncremental, boolean reverseRowKind) {
        this.init(snapshotId, partition, bucket, files, isIncremental, reverseRowKind);
    }

    private void init(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files, boolean isIncremental, boolean reverseRowKind) {
        this.snapshotId = snapshotId;
        this.partition = partition;
        this.bucket = bucket;
        this.files = files;
        this.isIncremental = isIncremental;
        this.reverseRowKind = reverseRowKind;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public List<DataFileMeta> files() {
        return this.files;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    public boolean reverseRowKind() {
        return this.reverseRowKind;
    }

    @Override
    public long rowCount() {
        long rowCount = 0L;
        for (DataFileMeta file : this.files) {
            rowCount += file.rowCount();
        }
        return rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSplit split = (DataSplit)o;
        return this.bucket == split.bucket && Objects.equals(this.partition, split.partition) && Objects.equals(this.files, split.files) && this.isIncremental == split.isIncremental && this.reverseRowKind == split.reverseRowKind;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.files, this.isIncremental, this.reverseRowKind);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(new DataOutputViewStreamWrapper(out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DataSplit split = DataSplit.deserialize(new DataInputViewStreamWrapper(in));
        this.init(split.snapshotId, split.partition, split.bucket, split.files, split.isIncremental, split.reverseRowKind);
    }

    public void serialize(DataOutputView out) throws IOException {
        out.writeLong(this.snapshotId);
        SerializationUtils.serializeBinaryRow(this.partition, out);
        out.writeInt(this.bucket);
        out.writeInt(this.files.size());
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (DataFileMeta file : this.files) {
            dataFileSer.serialize(file, out);
        }
        out.writeBoolean(this.isIncremental);
        out.writeBoolean(this.reverseRowKind);
    }

    public static DataSplit deserialize(DataInputView in) throws IOException {
        long snapshotId = in.readLong();
        BinaryRow partition = SerializationUtils.deserializeBinaryRow(in);
        int bucket = in.readInt();
        int fileNumber = in.readInt();
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(fileNumber);
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (int i = 0; i < fileNumber; ++i) {
            files.add((DataFileMeta)dataFileSer.deserialize(in));
        }
        return new DataSplit(snapshotId, partition, bucket, files, in.readBoolean(), in.readBoolean());
    }
}

