/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.source.AbstractInnerTableScan;
import org.apache.paimon.table.source.DataFilePlan;
import org.apache.paimon.table.source.EndOfScanException;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class InnerTableScanImpl
extends AbstractInnerTableScan {
    private final SnapshotManager snapshotManager;
    private StartingScanner startingScanner;
    private boolean hasNext;

    public InnerTableScanImpl(CoreOptions options, SnapshotSplitReader snapshotSplitReader, SnapshotManager snapshotManager) {
        super(options, snapshotSplitReader);
        this.snapshotManager = snapshotManager;
        this.hasNext = true;
    }

    @Override
    public InnerTableScan withFilter(Predicate predicate) {
        this.snapshotSplitReader.withFilter(predicate);
        return this;
    }

    @Override
    public DataFilePlan plan() {
        if (this.startingScanner == null) {
            this.startingScanner = this.createStartingScanner(false);
        }
        if (this.hasNext) {
            this.hasNext = false;
            StartingScanner.Result result = this.startingScanner.scan(this.snapshotManager, this.snapshotSplitReader);
            return DataFilePlan.fromResult(result);
        }
        throw new EndOfScanException();
    }
}

