/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactedStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactedStartingScanner.class);

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotSplitReader snapshotSplitReader) {
        Long startingSnapshotId = this.pick(snapshotManager);
        if (startingSnapshotId == null) {
            startingSnapshotId = snapshotManager.latestSnapshotId();
            if (startingSnapshotId == null) {
                LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
                return new StartingScanner.NoSnapshot();
            }
            LOG.debug("No compact snapshot found, reading from the latest snapshot {}.", (Object)startingSnapshotId);
        }
        return new StartingScanner.ScannedResult(startingSnapshotId, snapshotSplitReader.withKind(ScanKind.ALL).withSnapshot(startingSnapshotId).splits());
    }

    @Nullable
    protected Long pick(SnapshotManager snapshotManager) {
        return snapshotManager.latestCompactedSnapshotId();
    }
}

