/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.table.source.DataFilePlan;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.source.snapshot.FollowUpScanner;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousCompactorFollowUpScanner
implements FollowUpScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousCompactorFollowUpScanner.class);

    @Override
    public boolean shouldScanSnapshot(Snapshot snapshot) {
        if (snapshot.commitKind() == Snapshot.CommitKind.APPEND) {
            return true;
        }
        LOG.debug("Next snapshot id {} is not APPEND, but is {}, check next one.", (Object)snapshot.id(), (Object)snapshot.commitKind());
        return false;
    }

    @Override
    public TableScan.Plan scan(long snapshotId, SnapshotSplitReader snapshotSplitReader) {
        return new DataFilePlan(snapshotSplitReader.withKind(ScanKind.DELTA).withSnapshot(snapshotId).splits());
    }
}

