/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousCompactorStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousCompactorStartingScanner.class);

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotSplitReader snapshotSplitReader) {
        Long latestSnapshotId = snapshotManager.latestSnapshotId();
        Long earliestSnapshotId = snapshotManager.earliestSnapshotId();
        if (latestSnapshotId == null || earliestSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        for (long id = latestSnapshotId.longValue(); id >= earliestSnapshotId; --id) {
            Snapshot snapshot = snapshotManager.snapshot(id);
            if (snapshot.commitKind() != Snapshot.CommitKind.COMPACT) continue;
            LOG.debug("Found latest compact snapshot {}, reading from the next snapshot.", (Object)id);
            return new StartingScanner.NextSnapshot(id + 1L);
        }
        LOG.debug("No compact snapshot found, reading from the earliest snapshot {}.", (Object)earliestSnapshotId);
        return new StartingScanner.NextSnapshot(earliestSnapshotId);
    }
}

