/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousFromTimestampStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousFromTimestampStartingScanner.class);
    private final long startupMillis;

    public ContinuousFromTimestampStartingScanner(long startupMillis) {
        this.startupMillis = startupMillis;
    }

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotSplitReader snapshotSplitReader) {
        Long startingSnapshotId = snapshotManager.earlierThanTimeMills(this.startupMillis);
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        return new StartingScanner.NextSnapshot(startingSnapshotId + 1L);
    }
}

