/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.CompactedStartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class FullCompactedStartingScanner
extends CompactedStartingScanner {
    private final int deltaCommits;

    public FullCompactedStartingScanner(int deltaCommits) {
        this.deltaCommits = deltaCommits;
    }

    @Override
    @Nullable
    protected Long pick(SnapshotManager snapshotManager) {
        return snapshotManager.pickFromLatest(this::picked);
    }

    private boolean picked(Snapshot snapshot) {
        long identifier = snapshot.commitIdentifier();
        return snapshot.commitKind() == Snapshot.CommitKind.COMPACT && FullCompactedStartingScanner.isFullCompactedIdentifier(identifier, this.deltaCommits);
    }

    public static boolean isFullCompactedIdentifier(long identifier, int deltaCommits) {
        return identifier % (long)deltaCommits == 0L || identifier == Long.MAX_VALUE;
    }
}

