/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.snapshot.SnapshotSplitReader;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.SnapshotManager;

public class SnapshotSplitReaderImpl
implements SnapshotSplitReader {
    private final FileStoreScan scan;
    private final TableSchema tableSchema;
    private final CoreOptions options;
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SplitGenerator splitGenerator;
    private final BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer;
    private ScanKind scanKind = ScanKind.ALL;
    private RecordComparator lazyPartitionComparator;

    public SnapshotSplitReaderImpl(FileStoreScan scan, TableSchema tableSchema, CoreOptions options, SnapshotManager snapshotManager, SplitGenerator splitGenerator, BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer) {
        this.scan = scan;
        this.tableSchema = tableSchema;
        this.options = options;
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.splitGenerator = splitGenerator;
        this.nonPartitionFilterConsumer = nonPartitionFilterConsumer;
    }

    @Override
    public ConsumerManager consumerManager() {
        return this.consumerManager;
    }

    @Override
    public SnapshotSplitReader withSnapshot(long snapshotId) {
        this.scan.withSnapshot(snapshotId);
        return this;
    }

    @Override
    public SnapshotSplitReader withFilter(Predicate predicate) {
        List<String> partitionKeys = this.tableSchema.partitionKeys();
        int[] fieldIdxToPartitionIdx = this.tableSchema.fields().stream().mapToInt(f -> partitionKeys.indexOf(f.name())).toArray();
        ArrayList<Predicate> partitionFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> nonPartitionFilters = new ArrayList<Predicate>();
        for (Predicate p : PredicateBuilder.splitAnd(predicate)) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxToPartitionIdx);
            if (mapped.isPresent()) {
                partitionFilters.add(mapped.get());
                continue;
            }
            nonPartitionFilters.add(p);
        }
        if (partitionFilters.size() > 0) {
            this.scan.withPartitionFilter(PredicateBuilder.and(partitionFilters));
        }
        if (nonPartitionFilters.size() > 0) {
            this.nonPartitionFilterConsumer.accept(this.scan, PredicateBuilder.and(nonPartitionFilters));
        }
        return this;
    }

    @Override
    public SnapshotSplitReader withKind(ScanKind scanKind) {
        this.scanKind = scanKind;
        this.scan.withKind(scanKind);
        return this;
    }

    @Override
    public SnapshotSplitReader withLevelFilter(Filter<Integer> levelFilter) {
        this.scan.withLevelFilter(levelFilter);
        return this;
    }

    @Override
    public SnapshotSplitReader withBucket(int bucket) {
        this.scan.withBucket(bucket);
        return this;
    }

    @Override
    public List<DataSplit> splits() {
        FileStoreScan.Plan plan = this.scan.plan();
        Long snapshotId = plan.snapshotId();
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> files = FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.ADD));
        if (this.options.scanPlanSortPartition()) {
            LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>> newFiles = new LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>>();
            files.entrySet().stream().sorted((o1, o2) -> this.partitionComparator().compare((InternalRow)o1.getKey(), (InternalRow)o2.getKey())).forEach(entry -> {
                Map cfr_ignored_0 = (Map)newFiles.put((BinaryRow)entry.getKey(), (Map<Integer, List<DataFileMeta>>)entry.getValue());
            });
            files = newFiles;
        }
        return SnapshotSplitReaderImpl.generateSplits(snapshotId == null ? 0L : snapshotId, this.scanKind != ScanKind.ALL, false, this.splitGenerator, files);
    }

    @Override
    public List<DataSplit> overwriteSplits() {
        this.withKind(ScanKind.DELTA);
        FileStoreScan.Plan plan = this.scan.plan();
        long snapshotId = plan.snapshotId();
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        if (snapshot.commitKind() != Snapshot.CommitKind.OVERWRITE) {
            throw new IllegalStateException("Cannot read overwrite splits from a non-overwrite snapshot.");
        }
        ArrayList<DataSplit> splits = new ArrayList<DataSplit>();
        splits.addAll(SnapshotSplitReaderImpl.generateSplits(snapshotId, true, true, this.splitGenerator, FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.DELETE))));
        splits.addAll(SnapshotSplitReaderImpl.generateSplits(snapshotId, true, false, this.splitGenerator, FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.ADD))));
        return splits;
    }

    private RecordComparator partitionComparator() {
        if (this.lazyPartitionComparator == null) {
            this.lazyPartitionComparator = CodeGenUtils.newRecordComparator(this.tableSchema.logicalPartitionType().getFieldTypes(), "PartitionComparator");
        }
        return this.lazyPartitionComparator;
    }

    @VisibleForTesting
    public static List<DataSplit> generateSplits(long snapshotId, boolean isIncremental, boolean reverseRowKind, SplitGenerator splitGenerator, Map<BinaryRow, Map<Integer, List<DataFileMeta>>> groupedDataFiles) {
        ArrayList<DataSplit> splits = new ArrayList<DataSplit>();
        for (Map.Entry<BinaryRow, Map<Integer, List<DataFileMeta>>> entry : groupedDataFiles.entrySet()) {
            BinaryRow partition = entry.getKey();
            Map<Integer, List<DataFileMeta>> buckets = entry.getValue();
            for (Map.Entry<Integer, List<DataFileMeta>> bucketEntry : buckets.entrySet()) {
                int bucket = bucketEntry.getKey();
                if (isIncremental) {
                    splits.add(new DataSplit(snapshotId, partition, bucket, bucketEntry.getValue(), true, reverseRowKind));
                    continue;
                }
                splitGenerator.split(bucketEntry.getValue()).stream().map(files -> new DataSplit(snapshotId, partition, bucket, (List<DataFileMeta>)files, false, reverseRowKind)).forEach(splits::add);
            }
        }
        return splits;
    }
}

