/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.LazyGenericRow;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.apache.paimon.utils.SerializationUtils;

public class FilesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String FILES = "files";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "bucket", new IntType(false)), new DataField(2, "file_path", SerializationUtils.newStringType(false)), new DataField(3, "file_format", SerializationUtils.newStringType(false)), new DataField(4, "schema_id", new BigIntType(false)), new DataField(5, "level", new IntType(false)), new DataField(6, "record_count", new BigIntType(false)), new DataField(7, "file_size_in_bytes", new BigIntType(false)), new DataField(8, "min_key", SerializationUtils.newStringType(true)), new DataField(9, "max_key", SerializationUtils.newStringType(true)), new DataField(10, "null_value_counts", SerializationUtils.newStringType(false)), new DataField(11, "min_value_stats", SerializationUtils.newStringType(false)), new DataField(12, "max_value_stats", SerializationUtils.newStringType(false)), new DataField(13, "creation_time", DataTypes.TIMESTAMP_MILLIS())));
    private final FileStoreTable storeTable;

    public FilesTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + FILES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("file_path");
    }

    @Override
    public InnerTableScan newScan() {
        return new FilesScan(this.storeTable);
    }

    @Override
    public InnerTableRead newRead() {
        return new FilesRead(new SchemaManager(this.storeTable.fileIO(), this.storeTable.location()));
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new FilesTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    private static class StatsLazyGetter {
        private final BinaryTableStats tableStats;
        private final DataFileMeta file;
        private final FieldStatsConverters fieldStatsConverters;
        private Map<String, Long> lazyNullValueCounts;
        private Map<String, Object> lazyLowerValueBounds;
        private Map<String, Object> lazyUpperValueBounds;

        private StatsLazyGetter(BinaryTableStats tableStats, DataFileMeta file, FieldStatsConverters fieldStatsConverters) {
            this.tableStats = tableStats;
            this.file = file;
            this.fieldStatsConverters = fieldStatsConverters;
        }

        private void initialize() {
            FieldStatsArraySerializer fieldStatsArraySerializer = this.fieldStatsConverters.getOrCreate(this.file.schemaId());
            FieldStats[] fieldStatsArray = this.tableStats.fields(fieldStatsArraySerializer, this.file.rowCount());
            this.lazyNullValueCounts = new TreeMap<String, Long>();
            this.lazyLowerValueBounds = new TreeMap<String, Object>();
            this.lazyUpperValueBounds = new TreeMap<String, Object>();
            for (int i = 0; i < fieldStatsArray.length; ++i) {
                String fieldName = this.fieldStatsConverters.tableDataFields().get(i).name();
                FieldStats fieldStats = fieldStatsArray[i];
                this.lazyNullValueCounts.put(fieldName, fieldStats.nullCount());
                this.lazyLowerValueBounds.put(fieldName, fieldStats.minValue());
                this.lazyUpperValueBounds.put(fieldName, fieldStats.maxValue());
            }
        }

        private Map<String, Long> nullValueCounts() {
            if (this.lazyNullValueCounts == null) {
                this.initialize();
            }
            return this.lazyNullValueCounts;
        }

        private Map<String, Object> lowerValueBounds() {
            if (this.lazyLowerValueBounds == null) {
                this.initialize();
            }
            return this.lazyLowerValueBounds;
        }

        private Map<String, Object> upperValueBounds() {
            if (this.lazyUpperValueBounds == null) {
                this.initialize();
            }
            return this.lazyUpperValueBounds;
        }
    }

    private static class FilesRead
    implements InnerTableRead {
        private final SchemaManager schemaManager;
        private int[][] projection;

        private FilesRead(SchemaManager schemaManager) {
            this.schemaManager = schemaManager;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof FilesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            FilesSplit filesSplit = (FilesSplit)split;
            FileStoreTable table = filesSplit.storeTable;
            TableScan.Plan plan = filesSplit.plan();
            if (plan.splits().isEmpty()) {
                return new IteratorRecordReader<InternalRow>(Collections.emptyIterator());
            }
            ArrayList iteratorList = new ArrayList();
            FieldStatsConverters fieldStatsConverters = new FieldStatsConverters(sid -> this.schemaManager.schema((long)sid).fields(), table.schema().id());
            RowDataToObjectArrayConverter partitionConverter = new RowDataToObjectArrayConverter(table.schema().logicalPartitionType());
            Function<Long, RowDataToObjectArrayConverter> keyConverters = new Function<Long, RowDataToObjectArrayConverter>(){
                final Map<Long, RowDataToObjectArrayConverter> keyConverterMap = new HashMap<Long, RowDataToObjectArrayConverter>();

                @Override
                public RowDataToObjectArrayConverter apply(Long schemaId) {
                    return this.keyConverterMap.computeIfAbsent(schemaId, k -> {
                        TableSchema dataSchema = schemaManager.schema(schemaId);
                        RowType keysType = dataSchema.logicalTrimmedPrimaryKeysType();
                        return keysType.getFieldCount() > 0 ? new RowDataToObjectArrayConverter(dataSchema.logicalTrimmedPrimaryKeysType()) : new RowDataToObjectArrayConverter(dataSchema.logicalRowType());
                    });
                }
            };
            for (Split dataSplit : plan.splits()) {
                iteratorList.add(Iterators.transform(((DataSplit)dataSplit).files().iterator(), file -> this.toRow((DataSplit)dataSplit, partitionConverter, keyConverters, (DataFileMeta)file, table.getSchemaFieldStats((DataFileMeta)file), fieldStatsConverters)));
            }
            Iterator rows = Iterators.concat(iteratorList.iterator());
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private LazyGenericRow toRow(DataSplit dataSplit, RowDataToObjectArrayConverter partitionConverter, Function<Long, RowDataToObjectArrayConverter> keyConverters, DataFileMeta dataFileMeta, BinaryTableStats tableStats, FieldStatsConverters fieldStatsConverters) {
            StatsLazyGetter statsGetter = new StatsLazyGetter(tableStats, dataFileMeta, fieldStatsConverters);
            Supplier[] supplierArray = new Supplier[14];
            supplierArray[0] = () -> dataSplit.partition() == null ? null : BinaryString.fromString(Arrays.toString(partitionConverter.convert(dataSplit.partition())));
            supplierArray[1] = dataSplit::bucket;
            supplierArray[2] = () -> BinaryString.fromString(dataFileMeta.fileName());
            supplierArray[3] = () -> BinaryString.fromString(DataFilePathFactory.formatIdentifier(dataFileMeta.fileName()));
            supplierArray[4] = dataFileMeta::schemaId;
            supplierArray[5] = dataFileMeta::level;
            supplierArray[6] = dataFileMeta::rowCount;
            supplierArray[7] = dataFileMeta::fileSize;
            supplierArray[8] = () -> dataFileMeta.minKey().getFieldCount() <= 0 ? null : BinaryString.fromString(Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(dataFileMeta.schemaId())).convert(dataFileMeta.minKey())));
            supplierArray[9] = () -> dataFileMeta.minKey().getFieldCount() <= 0 ? null : BinaryString.fromString(Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(dataFileMeta.schemaId())).convert(dataFileMeta.maxKey())));
            supplierArray[10] = () -> BinaryString.fromString(statsGetter.nullValueCounts().toString());
            supplierArray[11] = () -> BinaryString.fromString(statsGetter.lowerValueBounds().toString());
            supplierArray[12] = () -> BinaryString.fromString(statsGetter.upperValueBounds().toString());
            supplierArray[13] = dataFileMeta::creationTime;
            Supplier[] fields = supplierArray;
            return new LazyGenericRow(fields);
        }
    }

    private static class FilesSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final FileStoreTable storeTable;

        private FilesSplit(FileStoreTable storeTable) {
            this.storeTable = storeTable;
        }

        @Override
        public long rowCount() {
            TableScan.Plan plan = this.plan();
            return plan.splits().stream().map(s -> (DataSplit)s).mapToLong(s -> s.files().size()).sum();
        }

        private TableScan.Plan plan() {
            return this.storeTable.newScan().plan();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilesSplit that = (FilesSplit)o;
            return Objects.equals(this.storeTable, that.storeTable);
        }

        public int hashCode() {
            return Objects.hash(this.storeTable);
        }
    }

    private static class FilesScan
    extends ReadOnceTableScan {
        private final FileStoreTable storeTable;

        private FilesScan(FileStoreTable storeTable) {
            this.storeTable = storeTable;
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new FilesSplit(this.storeTable));
        }
    }
}

