/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.table.system.FilesTable;
import org.apache.paimon.table.system.OptionsTable;
import org.apache.paimon.table.system.SchemasTable;
import org.apache.paimon.table.system.SnapshotsTable;

public class SystemTableLoader {
    @Nullable
    public static Table load(String type, FileIO fileIO, FileStoreTable dataTable) {
        Path location = dataTable.location();
        switch (type.toLowerCase()) {
            case "snapshots": {
                return new SnapshotsTable(fileIO, location);
            }
            case "options": {
                return new OptionsTable(fileIO, location);
            }
            case "schemas": {
                return new SchemasTable(fileIO, location);
            }
            case "audit_log": {
                return new AuditLogTable(dataTable);
            }
            case "files": {
                return new FilesTable(dataTable);
            }
        }
        return null;
    }
}

