/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public final class DataTypeChecks {
    private static final LengthExtractor LENGTH_EXTRACTOR = new LengthExtractor();
    private static final PrecisionExtractor PRECISION_EXTRACTOR = new PrecisionExtractor();
    private static final ScaleExtractor SCALE_EXTRACTOR = new ScaleExtractor();
    private static final FieldCountExtractor FIELD_COUNT_EXTRACTOR = new FieldCountExtractor();
    private static final FieldNamesExtractor FIELD_NAMES_EXTRACTOR = new FieldNamesExtractor();
    private static final FieldTypesExtractor FIELD_TYPES_EXTRACTOR = new FieldTypesExtractor();
    private static final NestedTypesExtractor NESTED_TYPES_EXTRACTOR = new NestedTypesExtractor();

    public static boolean isCompositeType(DataType dataType) {
        return dataType.getTypeRoot() == DataTypeRoot.ROW;
    }

    public static int getLength(DataType dataType) {
        return dataType.accept(LENGTH_EXTRACTOR);
    }

    public static boolean hasLength(DataType dataType, int length) {
        return DataTypeChecks.getLength(dataType) == length;
    }

    public static int getPrecision(DataType dataType) {
        return dataType.accept(PRECISION_EXTRACTOR);
    }

    public static boolean hasPrecision(DataType dataType, int precision) {
        return DataTypeChecks.getPrecision(dataType) == precision;
    }

    public static int getScale(DataType dataType) {
        return dataType.accept(SCALE_EXTRACTOR);
    }

    public static boolean hasScale(DataType dataType, int scale) {
        return DataTypeChecks.getScale(dataType) == scale;
    }

    public static int getFieldCount(DataType dataType) {
        return dataType.accept(FIELD_COUNT_EXTRACTOR);
    }

    public static List<String> getFieldNames(DataType dataType) {
        return dataType.accept(FIELD_NAMES_EXTRACTOR);
    }

    public static List<DataType> getFieldTypes(DataType dataType) {
        return dataType.accept(FIELD_TYPES_EXTRACTOR);
    }

    public static List<DataType> getNestedTypes(DataType dataType) {
        return dataType.accept(NESTED_TYPES_EXTRACTOR);
    }

    public static boolean hasWellDefinedString(DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    private DataTypeChecks() {
    }

    private static class NestedTypesExtractor
    extends Extractor<List<DataType>> {
        private NestedTypesExtractor() {
        }

        @Override
        public List<DataType> visit(ArrayType arrayType) {
            return Collections.singletonList(arrayType.getElementType());
        }

        @Override
        public List<DataType> visit(MultisetType multisetType) {
            return Collections.singletonList(multisetType.getElementType());
        }

        @Override
        public List<DataType> visit(MapType mapType) {
            return Arrays.asList(mapType.getKeyType(), mapType.getValueType());
        }

        @Override
        public List<DataType> visit(RowType rowType) {
            return rowType.getFieldTypes();
        }
    }

    private static class FieldTypesExtractor
    extends Extractor<List<DataType>> {
        private FieldTypesExtractor() {
        }

        @Override
        public List<DataType> visit(RowType rowType) {
            return rowType.getFieldTypes();
        }
    }

    private static class FieldNamesExtractor
    extends Extractor<List<String>> {
        private FieldNamesExtractor() {
        }

        @Override
        public List<String> visit(RowType rowType) {
            return rowType.getFieldNames();
        }
    }

    private static class FieldCountExtractor
    extends Extractor<Integer> {
        private FieldCountExtractor() {
        }

        @Override
        public Integer visit(RowType rowType) {
            return rowType.getFieldCount();
        }

        @Override
        protected Integer defaultMethod(DataType dataType) {
            return 1;
        }
    }

    private static class ScaleExtractor
    extends Extractor<Integer> {
        private ScaleExtractor() {
        }

        @Override
        public Integer visit(DecimalType decimalType) {
            return decimalType.getScale();
        }

        @Override
        public Integer visit(TinyIntType tinyIntType) {
            return 0;
        }

        @Override
        public Integer visit(SmallIntType smallIntType) {
            return 0;
        }

        @Override
        public Integer visit(IntType intType) {
            return 0;
        }

        @Override
        public Integer visit(BigIntType bigIntType) {
            return 0;
        }
    }

    private static class PrecisionExtractor
    extends Extractor<Integer> {
        private PrecisionExtractor() {
        }

        @Override
        public Integer visit(DecimalType decimalType) {
            return decimalType.getPrecision();
        }

        @Override
        public Integer visit(TimeType timeType) {
            return timeType.getPrecision();
        }

        @Override
        public Integer visit(TimestampType timestampType) {
            return timestampType.getPrecision();
        }

        @Override
        public Integer visit(LocalZonedTimestampType localZonedTimestampType) {
            return localZonedTimestampType.getPrecision();
        }
    }

    private static class LengthExtractor
    extends Extractor<Integer> {
        private LengthExtractor() {
        }

        @Override
        public Integer visit(CharType charType) {
            return charType.getLength();
        }

        @Override
        public Integer visit(VarCharType varCharType) {
            return varCharType.getLength();
        }

        @Override
        public Integer visit(BinaryType binaryType) {
            return binaryType.getLength();
        }

        @Override
        public Integer visit(VarBinaryType varBinaryType) {
            return varBinaryType.getLength();
        }
    }

    private static class Extractor<T>
    extends DataTypeDefaultVisitor<T> {
        private Extractor() {
        }

        @Override
        protected T defaultMethod(DataType dataType) {
            throw new IllegalArgumentException(String.format("Invalid use of extractor %s. Called on logical type: %s", this.getClass().getName(), dataType));
        }
    }
}

