/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;

public class FixBinPacking {
    private FixBinPacking() {
    }

    public static <T> List<List<T>> pack(Iterable<T> items, Function<T, Long> weightFunc, int binNumber) {
        ArrayList<Object> sorted = new ArrayList<Object>();
        items.forEach(sorted::add);
        sorted.sort(Comparator.comparingLong(weightFunc::apply));
        PriorityQueue<Bin> bins = new PriorityQueue<Bin>();
        for (Object e : sorted) {
            long weight = weightFunc.apply(e);
            Bin bin2 = bins.size() < binNumber ? new Bin() : (Bin)bins.poll();
            bin2.add(e, weight);
            bins.add(bin2);
        }
        ArrayList<List<T>> packed = new ArrayList<List<T>>();
        bins.forEach(bin -> packed.add(((Bin)bin).items));
        return packed;
    }

    private static class Bin<T>
    implements Comparable<Bin<T>> {
        private final List<T> items = new ArrayList<T>();
        private long binWeight = 0L;

        private Bin() {
        }

        void add(T item, long weight) {
            this.binWeight += weight;
            this.items.add(item);
        }

        @Override
        public int compareTo(Bin<T> other) {
            return Long.compare(this.binWeight, other.binWeight);
        }
    }
}

