/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.paimon.options.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final String[] CONFIG_PREFIXES = new String[]{"hadoop."};
    public static final String HADOOP_HOME_ENV = "HADOOP_HOME";
    public static final String HADOOP_CONF_ENV = "HADOOP_CONF_DIR";
    public static final String PATH_HADOOP_CONFIG = "hadoop-conf-dir";

    public static Configuration getHadoopConfiguration(Options options) {
        String hadoopConfDir;
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String[] possibleHadoopConfPaths = new String[2];
        String hadoopHomeDir = System.getenv(HADOOP_HOME_ENV);
        if (hadoopHomeDir != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHomeDir);
            possibleHadoopConfPaths[0] = hadoopHomeDir + "/conf";
            possibleHadoopConfPaths[1] = hadoopHomeDir + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, possibleHadoopConfPath);
        }
        String hadoopConfigPath = options.getString(PATH_HADOOP_CONFIG, null);
        if (hadoopConfigPath != null) {
            LOG.debug("Searching Hadoop configuration files in Paimon config: {}", (Object)hadoopConfigPath);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfigPath) || foundHadoopConfiguration;
        }
        if ((hadoopConfDir = System.getenv(HADOOP_CONF_ENV)) != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfDir) || foundHadoopConfiguration;
        }
        for (String key : options.keySet()) {
            for (String prefix : CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String newKey = key.substring(prefix.length());
                String value = options.getString(key, null);
                result.set(newKey, value);
                LOG.debug("Adding Paimon config entry for {} as {}={} to Hadoop config", new Object[]{key, newKey, value});
                foundHadoopConfiguration = true;
            }
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods");
        }
        return result;
    }

    private static boolean addHadoopConfIfFound(Configuration configuration, String possibleHadoopConfPath) {
        boolean foundHadoopConfiguration = false;
        if (new File(possibleHadoopConfPath).exists()) {
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
        }
        return foundHadoopConfiguration;
    }
}

