/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsCache;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;

public abstract class ObjectsFile<T> {
    protected final FileIO fileIO;
    protected final ObjectSerializer<T> serializer;
    protected final FormatReaderFactory readerFactory;
    protected final PathFactory pathFactory;
    @Nullable
    private final ObjectsCache<String, T> cache;

    protected ObjectsFile(FileIO fileIO, ObjectSerializer<T> serializer, FormatReaderFactory readerFactory, PathFactory pathFactory, @Nullable SegmentsCache<String> cache) {
        this.fileIO = fileIO;
        this.serializer = serializer;
        this.readerFactory = readerFactory;
        this.pathFactory = pathFactory;
        this.cache = cache == null ? null : new ObjectsCache<String, T>(cache, serializer, this::createIterator);
    }

    public List<T> read(String fileName) {
        return this.read(fileName, Filter.alwaysTrue(), Filter.alwaysTrue());
    }

    public List<T> read(String fileName, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter) {
        try {
            if (this.cache != null) {
                return this.cache.read(fileName, loadFilter, readFilter);
            }
            RecordReader<InternalRow> reader = FileUtils.createFormatReader(this.fileIO, this.readerFactory, this.pathFactory.toPath(fileName));
            if (readFilter != Filter.ALWAYS_TRUE) {
                reader = reader.filter(readFilter);
            }
            ArrayList result = new ArrayList();
            reader.forEachRemaining(row -> result.add(this.serializer.fromRow((InternalRow)row)));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read manifest list " + fileName, e);
        }
    }

    private CloseableIterator<InternalRow> createIterator(String fileName) {
        try {
            return FileUtils.createFormatReader(this.fileIO, this.readerFactory, this.pathFactory.toPath(fileName)).toCloseableIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }
}

