/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class OrderedPacking {
    private OrderedPacking() {
    }

    public static <T> List<List<T>> pack(Iterable<T> items, Function<T, Long> weightFunc, long targetWeight) {
        ArrayList<List<T>> packed = new ArrayList<List<T>>();
        ArrayList<T> binItems = new ArrayList<T>();
        long binWeight = 0L;
        for (T item : items) {
            long weight = weightFunc.apply(item);
            if (binWeight + weight > targetWeight) {
                packed.add(binItems);
                binItems = new ArrayList();
                binWeight = 0L;
            }
            binWeight += weight;
            binItems.add(item);
        }
        if (binItems.size() > 0) {
            packed.add(binItems);
        }
        return packed;
    }
}

