/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.stream.IntStream;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;

public class RowDataToObjectArrayConverter {
    private final RowType rowType;
    private final InternalRow.FieldGetter[] fieldGetters;

    public RowDataToObjectArrayConverter(RowType rowType) {
        this.rowType = rowType;
        this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, rowType.getFieldCount()).mapToObj(i -> InternalRowUtils.createNullCheckingFieldGetter(rowType.getTypeAt(i), i)).toArray(InternalRow.FieldGetter[]::new);
    }

    public RowType rowType() {
        return this.rowType;
    }

    public int getArity() {
        return this.fieldGetters.length;
    }

    public Object[] convert(InternalRow rowData) {
        Object[] result = new Object[this.fieldGetters.length];
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            result[i] = this.fieldGetters[i].getFieldOrNull(rowData);
        }
        return result;
    }
}

