/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.JsonSerdeUtil;

public class Snapshot {
    public static final long FIRST_SNAPSHOT_ID = 1L;
    public static final int TABLE_STORE_02_VERSION = 1;
    private static final int CURRENT_VERSION = 3;
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_ID = "id";
    private static final String FIELD_SCHEMA_ID = "schemaId";
    private static final String FIELD_BASE_MANIFEST_LIST = "baseManifestList";
    private static final String FIELD_DELTA_MANIFEST_LIST = "deltaManifestList";
    private static final String FIELD_CHANGELOG_MANIFEST_LIST = "changelogManifestList";
    private static final String FIELD_INDEX_MANIFEST = "indexManifest";
    private static final String FIELD_COMMIT_USER = "commitUser";
    private static final String FIELD_COMMIT_IDENTIFIER = "commitIdentifier";
    private static final String FIELD_COMMIT_KIND = "commitKind";
    private static final String FIELD_TIME_MILLIS = "timeMillis";
    private static final String FIELD_LOG_OFFSETS = "logOffsets";
    private static final String FIELD_TOTAL_RECORD_COUNT = "totalRecordCount";
    private static final String FIELD_DELTA_RECORD_COUNT = "deltaRecordCount";
    private static final String FIELD_CHANGELOG_RECORD_COUNT = "changelogRecordCount";
    private static final String FIELD_WATERMARK = "watermark";
    @JsonProperty(value="version")
    @Nullable
    private final Integer version;
    @JsonProperty(value="id")
    private final long id;
    @JsonProperty(value="schemaId")
    private final long schemaId;
    @JsonProperty(value="baseManifestList")
    private final String baseManifestList;
    @JsonProperty(value="deltaManifestList")
    private final String deltaManifestList;
    @JsonProperty(value="changelogManifestList")
    @Nullable
    private final String changelogManifestList;
    @JsonProperty(value="indexManifest")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String indexManifest;
    @JsonProperty(value="commitUser")
    private final String commitUser;
    @JsonProperty(value="commitIdentifier")
    private final long commitIdentifier;
    @JsonProperty(value="commitKind")
    private final CommitKind commitKind;
    @JsonProperty(value="timeMillis")
    private final long timeMillis;
    @JsonProperty(value="logOffsets")
    private final Map<Integer, Long> logOffsets;
    @JsonProperty(value="totalRecordCount")
    @Nullable
    private final Long totalRecordCount;
    @JsonProperty(value="deltaRecordCount")
    @Nullable
    private final Long deltaRecordCount;
    @JsonProperty(value="changelogRecordCount")
    @Nullable
    private final Long changelogRecordCount;
    @JsonProperty(value="watermark")
    @Nullable
    private final Long watermark;

    public Snapshot(long id, long schemaId, String baseManifestList, String deltaManifestList, @Nullable String changelogManifestList, @Nullable String indexManifest, String commitUser, long commitIdentifier, CommitKind commitKind, long timeMillis, Map<Integer, Long> logOffsets, @Nullable Long totalRecordCount, @Nullable Long deltaRecordCount, @Nullable Long changelogRecordCount, @Nullable Long watermark) {
        this(3, id, schemaId, baseManifestList, deltaManifestList, changelogManifestList, indexManifest, commitUser, commitIdentifier, commitKind, timeMillis, logOffsets, totalRecordCount, deltaRecordCount, changelogRecordCount, watermark);
    }

    @JsonCreator
    public Snapshot(@JsonProperty(value="version") @Nullable Integer version, @JsonProperty(value="id") long id, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="baseManifestList") String baseManifestList, @JsonProperty(value="deltaManifestList") String deltaManifestList, @JsonProperty(value="changelogManifestList") @Nullable String changelogManifestList, @JsonProperty(value="indexManifest") @Nullable String indexManifest, @JsonProperty(value="commitUser") String commitUser, @JsonProperty(value="commitIdentifier") long commitIdentifier, @JsonProperty(value="commitKind") CommitKind commitKind, @JsonProperty(value="timeMillis") long timeMillis, @JsonProperty(value="logOffsets") Map<Integer, Long> logOffsets, @JsonProperty(value="totalRecordCount") Long totalRecordCount, @JsonProperty(value="deltaRecordCount") Long deltaRecordCount, @JsonProperty(value="changelogRecordCount") Long changelogRecordCount, @JsonProperty(value="watermark") Long watermark) {
        this.version = version;
        this.id = id;
        this.schemaId = schemaId;
        this.baseManifestList = baseManifestList;
        this.deltaManifestList = deltaManifestList;
        this.changelogManifestList = changelogManifestList;
        this.indexManifest = indexManifest;
        this.commitUser = commitUser;
        this.commitIdentifier = commitIdentifier;
        this.commitKind = commitKind;
        this.timeMillis = timeMillis;
        this.logOffsets = logOffsets;
        this.totalRecordCount = totalRecordCount;
        this.deltaRecordCount = deltaRecordCount;
        this.changelogRecordCount = changelogRecordCount;
        this.watermark = watermark;
    }

    @JsonGetter(value="version")
    public int version() {
        return this.version == null ? 1 : this.version;
    }

    @JsonGetter(value="id")
    public long id() {
        return this.id;
    }

    @JsonGetter(value="schemaId")
    public long schemaId() {
        return this.schemaId;
    }

    @JsonGetter(value="baseManifestList")
    public String baseManifestList() {
        return this.baseManifestList;
    }

    @JsonGetter(value="deltaManifestList")
    public String deltaManifestList() {
        return this.deltaManifestList;
    }

    @JsonGetter(value="changelogManifestList")
    @Nullable
    public String changelogManifestList() {
        return this.changelogManifestList;
    }

    @JsonGetter(value="indexManifest")
    @Nullable
    public String indexManifest() {
        return this.indexManifest;
    }

    @JsonGetter(value="commitUser")
    public String commitUser() {
        return this.commitUser;
    }

    @JsonGetter(value="commitIdentifier")
    public long commitIdentifier() {
        return this.commitIdentifier;
    }

    @JsonGetter(value="commitKind")
    public CommitKind commitKind() {
        return this.commitKind;
    }

    @JsonGetter(value="timeMillis")
    public long timeMillis() {
        return this.timeMillis;
    }

    @JsonGetter(value="logOffsets")
    public Map<Integer, Long> logOffsets() {
        return this.logOffsets;
    }

    @JsonGetter(value="totalRecordCount")
    @Nullable
    public Long totalRecordCount() {
        return this.totalRecordCount;
    }

    @JsonGetter(value="deltaRecordCount")
    @Nullable
    public Long deltaRecordCount() {
        return this.deltaRecordCount;
    }

    @JsonGetter(value="changelogRecordCount")
    @Nullable
    public Long changelogRecordCount() {
        return this.changelogRecordCount;
    }

    @JsonGetter(value="watermark")
    @Nullable
    public Long watermark() {
        return this.watermark;
    }

    public List<ManifestFileMeta> allManifests(ManifestList manifestList) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(this.dataManifests(manifestList));
        result.addAll(this.changelogManifests(manifestList));
        return result;
    }

    public List<ManifestFileMeta> dataManifests(ManifestList manifestList) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(manifestList.read(this.baseManifestList));
        result.addAll(this.deltaManifests(manifestList));
        return result;
    }

    public List<ManifestFileMeta> deltaManifests(ManifestList manifestList) {
        return manifestList.read(this.deltaManifestList);
    }

    public List<ManifestFileMeta> changelogManifests(ManifestList manifestList) {
        return this.changelogManifestList == null ? Collections.emptyList() : manifestList.read(this.changelogManifestList);
    }

    public Long totalRecordCount(FileStoreScan scan) {
        return this.totalRecordCount == null ? Snapshot.recordCount(scan.withSnapshot(this.id).plan().files()) : this.totalRecordCount;
    }

    public static long recordCount(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountAdd(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.ADD.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountDelete(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.DELETE.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public static Snapshot fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Snapshot.class);
    }

    public static Snapshot fromPath(FileIO fileIO, Path path) {
        try {
            String json = fileIO.readFileUtf8(path);
            return Snapshot.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read snapshot from path " + path, e);
        }
    }

    public static Optional<Snapshot> safelyFromPath(FileIO fileIO, Path path) throws IOException {
        try {
            String json = fileIO.readFileUtf8(path);
            return Optional.of(Snapshot.fromJson(json));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.id, this.schemaId, this.baseManifestList, this.deltaManifestList, this.changelogManifestList, this.indexManifest, this.commitUser, this.commitIdentifier, this.commitKind, this.timeMillis, this.logOffsets, this.totalRecordCount, this.deltaRecordCount, this.changelogRecordCount, this.watermark});
    }

    public boolean equals(Object o) {
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        return Objects.equals(this.version, that.version) && this.id == that.id && this.schemaId == that.schemaId && Objects.equals(this.baseManifestList, that.baseManifestList) && Objects.equals(this.deltaManifestList, that.deltaManifestList) && Objects.equals(this.changelogManifestList, that.changelogManifestList) && Objects.equals(this.indexManifest, that.indexManifest) && Objects.equals(this.commitUser, that.commitUser) && this.commitIdentifier == that.commitIdentifier && this.commitKind == that.commitKind && this.timeMillis == that.timeMillis && Objects.equals(this.logOffsets, that.logOffsets) && Objects.equals(this.totalRecordCount, that.totalRecordCount) && Objects.equals(this.deltaRecordCount, that.deltaRecordCount) && Objects.equals(this.changelogRecordCount, that.changelogRecordCount) && Objects.equals(this.watermark, that.watermark);
    }

    public static enum CommitKind {
        APPEND,
        COMPACT,
        OVERWRITE;

    }
}

