/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.Closeable;
import java.io.IOException;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.disk.ExternalBuffer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.InMemoryBuffer;
import org.apache.paimon.memory.MemorySegmentPool;

public interface RowBuffer {
    public boolean put(InternalRow var1) throws IOException;

    public int size();

    public long memoryOccupancy();

    public void complete();

    public void reset();

    public RowBufferIterator newIterator();

    public static RowBuffer getBuffer(IOManager ioManager, MemorySegmentPool memoryPool, AbstractRowDataSerializer<InternalRow> serializer, boolean spillable) {
        if (spillable) {
            return new ExternalBuffer(ioManager, memoryPool, serializer);
        }
        return new InMemoryBuffer(memoryPool, serializer);
    }

    public static interface RowBufferIterator
    extends Closeable {
        public boolean advanceNext();

        public BinaryRow getRow();

        @Override
        public void close();
    }
}

