/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.util.List;
import org.apache.paimon.shade.org.apache.avro.LogicalType;
import org.apache.paimon.shade.org.apache.avro.LogicalTypes;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.SchemaBuilder;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;

public class AvroSchemaConverter {
    private AvroSchemaConverter() {
    }

    public static Schema convertToSchema(DataType schema) {
        return AvroSchemaConverter.convertToSchema(schema, "org.apache.paimon.avro.generated.record");
    }

    public static Schema convertToSchema(DataType dataType, String rowName) {
        boolean nullable = dataType.isNullable();
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                Schema bool = (Schema)SchemaBuilder.builder().booleanType();
                return nullable ? AvroSchemaConverter.nullableSchema(bool) : bool;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                Schema integer = (Schema)SchemaBuilder.builder().intType();
                return nullable ? AvroSchemaConverter.nullableSchema(integer) : integer;
            }
            case BIGINT: {
                Schema bigint = (Schema)SchemaBuilder.builder().longType();
                return nullable ? AvroSchemaConverter.nullableSchema(bigint) : bigint;
            }
            case FLOAT: {
                Schema f = (Schema)SchemaBuilder.builder().floatType();
                return nullable ? AvroSchemaConverter.nullableSchema(f) : f;
            }
            case DOUBLE: {
                Schema d = (Schema)SchemaBuilder.builder().doubleType();
                return nullable ? AvroSchemaConverter.nullableSchema(d) : d;
            }
            case CHAR: 
            case VARCHAR: {
                Schema str = (Schema)SchemaBuilder.builder().stringType();
                return nullable ? AvroSchemaConverter.nullableSchema(str) : str;
            }
            case BINARY: 
            case VARBINARY: {
                Schema binary = (Schema)SchemaBuilder.builder().bytesType();
                return nullable ? AvroSchemaConverter.nullableSchema(binary) : binary;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                LogicalType avroLogicalType;
                TimestampType timestampType = (TimestampType)dataType;
                int precision = timestampType.getPrecision();
                if (precision <= 3) {
                    avroLogicalType = LogicalTypes.timestampMillis();
                } else if (precision <= 6) {
                    avroLogicalType = LogicalTypes.timestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than 6.");
                }
                Schema timestamp = avroLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(timestamp) : timestamp;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LogicalType localTimestampLogicalType;
                LocalZonedTimestampType localTimestampType = (LocalZonedTimestampType)dataType;
                int precision = localTimestampType.getPrecision();
                if (precision <= 3) {
                    localTimestampLogicalType = LogicalTypes.localTimestampMillis();
                } else if (precision <= 6) {
                    localTimestampLogicalType = LogicalTypes.localTimestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than 6.");
                }
                Schema localTimestampSchema = localTimestampLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(localTimestampSchema) : localTimestampSchema;
            }
            case DATE: {
                Schema date = LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(date) : date;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                int precision = ((TimeType)dataType).getPrecision();
                if (precision > 3) {
                    throw new IllegalArgumentException("Avro does not support TIME type with precision: " + precision + ", it only supports precision less than 3.");
                }
                Schema time = LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(time) : time;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                Schema decimal = LogicalTypes.decimal(decimalType.getPrecision(), decimalType.getScale()).addToSchema((Schema)SchemaBuilder.builder().bytesType());
                return nullable ? AvroSchemaConverter.nullableSchema(decimal) : decimal;
            }
            case ROW: {
                RowType rowType = (RowType)dataType;
                List<String> fieldNames = rowType.getFieldNames();
                SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record(rowName).fields();
                for (int i = 0; i < rowType.getFieldCount(); ++i) {
                    String fieldName = fieldNames.get(i);
                    DataType fieldType = rowType.getTypeAt(i);
                    SchemaBuilder.GenericDefault fieldBuilder = builder.name(fieldName).type(AvroSchemaConverter.convertToSchema(fieldType, rowName + "_" + fieldName));
                    builder = fieldType.isNullable() ? fieldBuilder.withDefault(null) : fieldBuilder.noDefault();
                }
                Schema record = (Schema)builder.endRecord();
                return nullable ? AvroSchemaConverter.nullableSchema(record) : record;
            }
            case MULTISET: 
            case MAP: {
                Schema map = (Schema)SchemaBuilder.builder().map().values(AvroSchemaConverter.convertToSchema(AvroSchemaConverter.extractValueTypeToAvroMap(dataType), rowName));
                return nullable ? AvroSchemaConverter.nullableSchema(map) : map;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                Schema array = (Schema)SchemaBuilder.builder().array().items(AvroSchemaConverter.convertToSchema(arrayType.getElementType(), rowName));
                return nullable ? AvroSchemaConverter.nullableSchema(array) : array;
            }
        }
        throw new UnsupportedOperationException("Unsupported to derive Schema for type: " + dataType);
    }

    public static DataType extractValueTypeToAvroMap(DataType type) {
        DataType valueType;
        DataType keyType;
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            keyType = mapType.getKeyType();
            valueType = mapType.getValueType();
        } else {
            MultisetType multisetType = (MultisetType)type;
            keyType = multisetType.getElementType();
            valueType = new IntType();
        }
        if (keyType.getTypeRoot() != DataTypeRoot.VARCHAR && keyType.getTypeRoot() != DataTypeRoot.CHAR) {
            throw new UnsupportedOperationException("Avro format doesn't support non-string as key type of map. The key type is: " + keyType.asSQLString());
        }
        return valueType;
    }

    private static Schema nullableSchema(Schema schema) {
        return schema.isNullable() ? schema : Schema.createUnion((Schema)SchemaBuilder.builder().nullType(), schema);
    }
}

